/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Iterator;
import java.util.function.Function;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.procedures.ProcedureDescriptor;
import org.neo4j.kernel.api.procedures.ProcedureSignature;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.PropertyValueComparison;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.index.IndexPopulationProgress;
import org.neo4j.kernel.impl.api.store.DiskLayer;
import org.neo4j.kernel.impl.api.store.ProcedureCache;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.util.PrimitiveLongResourceIterator;

public class CacheLayer
implements StoreReadLayer {
    private static final Function<? super SchemaRule, IndexDescriptor> TO_INDEX_RULE = from -> {
        IndexRule rule = (IndexRule)from;
        return new IndexDescriptor(rule.getLabel(), rule.getPropertyKey());
    };
    private final ProcedureCache procedureCache;
    private final SchemaCache schemaCache;
    private final DiskLayer diskLayer;

    public CacheLayer(DiskLayer diskLayer, SchemaCache schemaCache, ProcedureCache procedureCache) {
        this.diskLayer = diskLayer;
        this.schemaCache = schemaCache;
        this.procedureCache = procedureCache;
    }

    @Override
    public StoreStatement acquireStatement() {
        return this.diskLayer.acquireStatement();
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(int labelId) {
        return CacheLayer.toIndexDescriptors(this.schemaCache.schemaRulesForLabel(labelId), SchemaRule.Kind.INDEX_RULE);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll() {
        return CacheLayer.toIndexDescriptors(this.schemaCache.schemaRules(), SchemaRule.Kind.INDEX_RULE);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(int labelId) {
        return CacheLayer.toIndexDescriptors(this.schemaCache.schemaRulesForLabel(labelId), SchemaRule.Kind.CONSTRAINT_INDEX_RULE);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll() {
        return CacheLayer.toIndexDescriptors(this.schemaCache.schemaRules(), SchemaRule.Kind.CONSTRAINT_INDEX_RULE);
    }

    private static Iterator<IndexDescriptor> toIndexDescriptors(Iterable<SchemaRule> rules, SchemaRule.Kind kind) {
        Iterator<SchemaRule> filteredRules = Iterables.filter(item -> item.getKind() == kind, rules.iterator());
        return Iterables.map(TO_INDEX_RULE, filteredRules);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) throws SchemaRuleNotFoundException {
        IndexRule rule = this.indexRule(index, SchemaStorage.IndexRuleKind.ALL);
        if (rule != null) {
            return rule.getOwningConstraint();
        }
        return this.diskLayer.indexGetOwningUniquenessConstraintId(index);
    }

    @Override
    public long indexGetCommittedId(IndexDescriptor index, SchemaStorage.IndexRuleKind kind) throws SchemaRuleNotFoundException {
        IndexRule rule = this.indexRule(index, kind);
        if (rule != null) {
            return rule.getId();
        }
        return this.diskLayer.indexGetCommittedId(index, kind);
    }

    @Override
    public IndexRule indexRule(IndexDescriptor index, SchemaStorage.IndexRuleKind kind) {
        for (SchemaRule rule : this.schemaCache.schemaRulesForLabel(index.getLabelId())) {
            IndexRule indexRule;
            if (!(rule instanceof IndexRule) || !kind.isOfKind(indexRule = (IndexRule)rule) || indexRule.getPropertyKey() != index.getPropertyKeyId()) continue;
            return indexRule;
        }
        return null;
    }

    @Override
    public PrimitiveIntIterator graphGetPropertyKeys(KernelStatement state) {
        return this.diskLayer.graphGetPropertyKeys(state);
    }

    @Override
    public Object graphGetProperty(int propertyKeyId) {
        return this.diskLayer.graphGetProperty(propertyKeyId);
    }

    @Override
    public Iterator<DefinedProperty> graphGetAllProperties() {
        return this.diskLayer.graphGetAllProperties();
    }

    @Override
    public Iterator<NodePropertyConstraint> constraintsGetForLabelAndPropertyKey(int labelId, int propertyKeyId) {
        return this.schemaCache.constraintsForLabelAndProperty(labelId, propertyKeyId);
    }

    @Override
    public Iterator<NodePropertyConstraint> constraintsGetForLabel(int labelId) {
        return this.schemaCache.constraintsForLabel(labelId);
    }

    @Override
    public Iterator<RelationshipPropertyConstraint> constraintsGetForRelationshipTypeAndPropertyKey(int typeId, int propertyKeyId) {
        return this.schemaCache.constraintsForRelationshipTypeAndProperty(typeId, propertyKeyId);
    }

    @Override
    public Iterator<RelationshipPropertyConstraint> constraintsGetForRelationshipType(int typeId) {
        return this.schemaCache.constraintsForRelationshipType(typeId);
    }

    @Override
    public Iterator<PropertyConstraint> constraintsGetAll() {
        return this.schemaCache.constraints();
    }

    @Override
    public PrimitiveLongResourceIterator nodeGetFromUniqueIndexSeek(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        return this.diskLayer.nodeGetFromUniqueIndexSeek(state, index, value);
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(KernelStatement state, int labelId) {
        return this.diskLayer.nodesGetForLabel(state, labelId);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexSeek(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        return this.diskLayer.nodesGetFromIndexSeek(state, index, value);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromInclusiveNumericIndexRangeSeek(KernelStatement state, IndexDescriptor index, Number lower, Number upper) throws IndexNotFoundKernelException {
        return this.diskLayer.nodesGetFromInclusiveNumericIndexRangeSeek(state, index, lower, upper);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexRangeSeekByString(KernelStatement state, IndexDescriptor index, String lower, boolean includeLower, String upper, boolean includeUpper) throws IndexNotFoundKernelException {
        return PropertyValueComparison.COMPARE_STRINGS.isEmptyRange(lower, includeLower, upper, includeUpper) ? PrimitiveLongCollections.emptyIterator() : this.diskLayer.nodesGetFromIndexRangeSeekByString(state, index, lower, includeLower, upper, includeUpper);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexRangeSeekByPrefix(KernelStatement state, IndexDescriptor index, String prefix) throws IndexNotFoundKernelException {
        return this.diskLayer.nodesGetFromIndexRangeSeekByPrefix(state, index, prefix);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexScan(KernelStatement state, IndexDescriptor index) throws IndexNotFoundKernelException {
        return this.diskLayer.nodesGetFromIndexScan(state, index);
    }

    @Override
    public IndexDescriptor indexesGetForLabelAndPropertyKey(int labelId, int propertyKey) {
        return this.schemaCache.indexDescriptor(labelId, propertyKey);
    }

    @Override
    public InternalIndexState indexGetState(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.diskLayer.indexGetState(descriptor);
    }

    @Override
    public IndexPopulationProgress indexGetPopulationProgress(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.diskLayer.indexGetPopulationProgress(descriptor);
    }

    @Override
    public long indexSize(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.diskLayer.indexSize(descriptor);
    }

    @Override
    public double indexUniqueValuesPercentage(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.diskLayer.indexUniqueValuesPercentage(descriptor);
    }

    @Override
    public Iterator<ProcedureDescriptor> proceduresGetAll() {
        return this.procedureCache.getAll();
    }

    @Override
    public ProcedureDescriptor procedureGet(ProcedureSignature.ProcedureName name) {
        return this.procedureCache.get(name);
    }

    @Override
    public String indexGetFailure(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.diskLayer.indexGetFailure(descriptor);
    }

    @Override
    public int labelGetForName(String labelName) {
        return this.diskLayer.labelGetForName(labelName);
    }

    @Override
    public String labelGetName(int labelId) throws LabelNotFoundKernelException {
        return this.diskLayer.labelGetName(labelId);
    }

    @Override
    public int propertyKeyGetForName(String propertyKeyName) {
        return this.diskLayer.propertyKeyGetForName(propertyKeyName);
    }

    @Override
    public int propertyKeyGetOrCreateForName(String propertyKeyName) {
        return this.diskLayer.propertyKeyGetOrCreateForName(propertyKeyName);
    }

    @Override
    public String propertyKeyGetName(int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        return this.diskLayer.propertyKeyGetName(propertyKeyId);
    }

    @Override
    public Iterator<Token> propertyKeyGetAllTokens() {
        return this.diskLayer.propertyKeyGetAllTokens();
    }

    @Override
    public Iterator<Token> labelsGetAllTokens() {
        return this.diskLayer.labelsGetAllTokens();
    }

    @Override
    public Iterator<Token> relationshipTypeGetAllTokens() {
        return this.diskLayer.relationshipTypeGetAllTokens();
    }

    @Override
    public int relationshipTypeGetForName(String relationshipTypeName) {
        return this.diskLayer.relationshipTypeGetForName(relationshipTypeName);
    }

    @Override
    public String relationshipTypeGetName(int relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        return this.diskLayer.relationshipTypeGetName(relationshipTypeId);
    }

    @Override
    public int labelGetOrCreateForName(String labelName) throws TooManyLabelsException {
        return this.diskLayer.labelGetOrCreateForName(labelName);
    }

    @Override
    public int relationshipTypeGetOrCreateForName(String relationshipTypeName) {
        return this.diskLayer.relationshipTypeGetOrCreateForName(relationshipTypeName);
    }

    @Override
    public <EXCEPTION extends Exception> void relationshipVisit(long relationshipId, RelationshipVisitor<EXCEPTION> relationshipVisitor) throws EntityNotFoundException, EXCEPTION {
        this.diskLayer.relationshipVisit(relationshipId, relationshipVisitor);
    }

    @Override
    public long countsForNode(int labelId) {
        return this.diskLayer.countsForNode(labelId);
    }

    @Override
    public long countsForRelationship(int startLabelId, int typeId, int endLabelId) {
        return this.diskLayer.countsForRelationship(startLabelId, typeId, endLabelId);
    }

    @Override
    public long highestNodeIdInUse() {
        return this.diskLayer.highestNodeIdInUse();
    }

    @Override
    public PrimitiveLongIterator nodesGetAll() {
        return this.diskLayer.nodesGetAll();
    }

    @Override
    public RelationshipIterator relationshipsGetAll() {
        return this.diskLayer.relationshipsGetAll();
    }

    @Override
    public long reserveNode() {
        return this.diskLayer.reserveNode();
    }

    @Override
    public long reserveRelationship() {
        return this.diskLayer.reserveRelationship();
    }

    @Override
    public void releaseNode(long id) {
        this.diskLayer.releaseNode(id);
    }

    @Override
    public void releaseRelationship(long id) {
        this.diskLayer.releaseRelationship(id);
    }
}

