/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.kernel.api.constraints.NodePropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DuplicateSchemaRuleException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.procedures.ProcedureDescriptor;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.txstate.LegacyIndexTransactionState;
import org.neo4j.kernel.api.txstate.TxStateVisitor;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.store.ProcedureCache;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.RelationshipPropertyExistenceConstraintRule;
import org.neo4j.kernel.impl.store.record.UniquePropertyConstraintRule;
import org.neo4j.kernel.impl.transaction.state.TransactionRecordState;

public class TransactionToRecordStateVisitor
extends TxStateVisitor.Adapter {
    private boolean clearSchemaState;
    private final TransactionRecordState recordState;
    private final Runnable schemaStateChangeCallback;
    private final SchemaStorage schemaStorage;
    private final ConstraintSemantics constraintSemantics;
    private final SchemaIndexProviderMap schemaIndexProviderMap;
    private final LegacyIndexTransactionState legacyIndexTransactionState;
    private final ProcedureCache procedureCache;

    public TransactionToRecordStateVisitor(TransactionRecordState recordState, Runnable schemaStateChangeCallback, SchemaStorage schemaStorage, ConstraintSemantics constraintSemantics, SchemaIndexProviderMap schemaIndexProviderMap, LegacyIndexTransactionState legacyIndexTransactionState, ProcedureCache procedureCache) {
        this.recordState = recordState;
        this.schemaStateChangeCallback = schemaStateChangeCallback;
        this.schemaStorage = schemaStorage;
        this.constraintSemantics = constraintSemantics;
        this.schemaIndexProviderMap = schemaIndexProviderMap;
        this.legacyIndexTransactionState = legacyIndexTransactionState;
        this.procedureCache = procedureCache;
    }

    @Override
    public void close() {
        try {
            if (this.clearSchemaState) {
                this.schemaStateChangeCallback.run();
            }
        }
        finally {
            this.clearSchemaState = false;
        }
    }

    @Override
    public void visitCreatedNode(long id) {
        this.recordState.nodeCreate(id);
    }

    @Override
    public void visitDeletedNode(long id) {
        this.recordState.nodeDelete(id);
    }

    @Override
    public void visitCreatedRelationship(long id, int type, long startNode, long endNode) {
        this.recordState.relCreate(id, type, startNode, endNode);
    }

    @Override
    public void visitDeletedRelationship(long id) {
        this.recordState.relDelete(id);
    }

    @Override
    public void visitNodePropertyChanges(long id, Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed, Iterator<Integer> removed) {
        DefinedProperty prop;
        while (removed.hasNext()) {
            this.recordState.nodeRemoveProperty(id, removed.next());
        }
        while (changed.hasNext()) {
            prop = changed.next();
            this.recordState.nodeChangeProperty(id, prop.propertyKeyId(), prop.value());
        }
        while (added.hasNext()) {
            prop = added.next();
            this.recordState.nodeAddProperty(id, prop.propertyKeyId(), prop.value());
        }
    }

    @Override
    public void visitRelPropertyChanges(long id, Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed, Iterator<Integer> removed) {
        DefinedProperty prop;
        while (removed.hasNext()) {
            this.recordState.relRemoveProperty(id, removed.next());
        }
        while (changed.hasNext()) {
            prop = changed.next();
            this.recordState.relChangeProperty(id, prop.propertyKeyId(), prop.value());
        }
        while (added.hasNext()) {
            prop = added.next();
            this.recordState.relAddProperty(id, prop.propertyKeyId(), prop.value());
        }
    }

    @Override
    public void visitGraphPropertyChanges(Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed, Iterator<Integer> removed) {
        DefinedProperty prop;
        while (removed.hasNext()) {
            this.recordState.graphRemoveProperty(removed.next());
        }
        while (changed.hasNext()) {
            prop = changed.next();
            this.recordState.graphChangeProperty(prop.propertyKeyId(), prop.value());
        }
        while (added.hasNext()) {
            prop = added.next();
            this.recordState.graphAddProperty(prop.propertyKeyId(), prop.value());
        }
    }

    @Override
    public void visitNodeLabelChanges(long id, Set<Integer> added, Set<Integer> removed) {
        for (Integer label : removed) {
            this.recordState.removeLabelFromNode(label, id);
        }
        for (Integer label : added) {
            this.recordState.addLabelToNode(label, id);
        }
    }

    @Override
    public void visitAddedIndex(IndexDescriptor element, boolean isConstraintIndex) {
        SchemaIndexProvider.Descriptor providerDescriptor = this.schemaIndexProviderMap.getDefaultProvider().getProviderDescriptor();
        IndexRule rule = isConstraintIndex ? IndexRule.constraintIndexRule(this.schemaStorage.newRuleId(), element.getLabelId(), element.getPropertyKeyId(), providerDescriptor, null) : IndexRule.indexRule(this.schemaStorage.newRuleId(), element.getLabelId(), element.getPropertyKeyId(), providerDescriptor);
        this.recordState.createSchemaRule(rule);
    }

    @Override
    public void visitRemovedIndex(IndexDescriptor element, boolean isConstraintIndex) {
        SchemaStorage.IndexRuleKind kind = isConstraintIndex ? SchemaStorage.IndexRuleKind.CONSTRAINT : SchemaStorage.IndexRuleKind.INDEX;
        IndexRule rule = this.schemaStorage.indexRule(element.getLabelId(), element.getPropertyKeyId(), kind);
        this.recordState.dropSchemaRule(rule);
    }

    @Override
    public void visitAddedUniquePropertyConstraint(UniquenessConstraint element) {
        this.clearSchemaState = true;
        long constraintId = this.schemaStorage.newRuleId();
        IndexRule indexRule = this.schemaStorage.indexRule(element.label(), element.propertyKey(), SchemaStorage.IndexRuleKind.CONSTRAINT);
        this.recordState.createSchemaRule(this.constraintSemantics.writeUniquePropertyConstraint(constraintId, element.label(), element.propertyKey(), indexRule.getId()));
        this.recordState.setConstraintIndexOwner(indexRule, constraintId);
    }

    @Override
    public void visitRemovedUniquePropertyConstraint(UniquenessConstraint element) {
        try {
            this.clearSchemaState = true;
            UniquePropertyConstraintRule rule = this.schemaStorage.uniquenessConstraint(element.label(), element.propertyKey());
            this.recordState.dropSchemaRule(rule);
        }
        catch (SchemaRuleNotFoundException e) {
            throw new ThisShouldNotHappenError("Tobias Lindaaker", "Constraint to be removed should exist, since its existence should have been validated earlier and the schema should have been locked.");
        }
        catch (DuplicateSchemaRuleException de) {
            throw new IllegalStateException("Multiple constraints found for specified label and property.");
        }
        this.visitRemovedIndex(new IndexDescriptor(element.label(), element.propertyKey()), true);
    }

    @Override
    public void visitAddedNodePropertyExistenceConstraint(NodePropertyExistenceConstraint element) throws CreateConstraintFailureException {
        this.clearSchemaState = true;
        this.recordState.createSchemaRule(this.constraintSemantics.writeNodePropertyExistenceConstraint(this.schemaStorage.newRuleId(), element.label(), element.propertyKey()));
    }

    @Override
    public void visitRemovedNodePropertyExistenceConstraint(NodePropertyExistenceConstraint element) {
        try {
            this.clearSchemaState = true;
            this.recordState.dropSchemaRule(this.schemaStorage.nodePropertyExistenceConstraint(element.label(), element.propertyKey()));
        }
        catch (SchemaRuleNotFoundException e) {
            throw new IllegalStateException("Node property existence constraint to be removed should exist, since its existence should have been validated earlier and the schema should have been locked.");
        }
        catch (DuplicateSchemaRuleException de) {
            throw new IllegalStateException("Multiple node property constraints found for specified label and property.");
        }
    }

    @Override
    public void visitAddedRelationshipPropertyExistenceConstraint(RelationshipPropertyExistenceConstraint element) throws CreateConstraintFailureException {
        this.clearSchemaState = true;
        this.recordState.createSchemaRule(this.constraintSemantics.writeRelationshipPropertyExistenceConstraint(this.schemaStorage.newRuleId(), element.relationshipType(), element.propertyKey()));
    }

    @Override
    public void visitRemovedRelationshipPropertyExistenceConstraint(RelationshipPropertyExistenceConstraint element) {
        try {
            this.clearSchemaState = true;
            RelationshipPropertyExistenceConstraintRule rule = this.schemaStorage.relationshipPropertyExistenceConstraint(element.relationshipType(), element.propertyKey());
            this.recordState.dropSchemaRule(rule);
        }
        catch (SchemaRuleNotFoundException e) {
            throw new IllegalStateException("Relationship property existence constraint to be removed should exist, since its existence should have been validated earlier and the schema should have been locked.");
        }
        catch (DuplicateSchemaRuleException re) {
            throw new IllegalStateException("Multiple relationship property constraints found for specified property and relationship type.");
        }
    }

    @Override
    public void visitCreatedLabelToken(String name, int id) {
        this.recordState.createLabelToken(name, id);
    }

    @Override
    public void visitCreatedPropertyKeyToken(String name, int id) {
        this.recordState.createPropertyKeyToken(name, id);
    }

    @Override
    public void visitCreatedRelationshipTypeToken(String name, int id) {
        this.recordState.createRelationshipTypeToken(name, id);
    }

    @Override
    public void visitCreatedNodeLegacyIndex(String name, Map<String, String> config) {
        this.legacyIndexTransactionState.createIndex(IndexEntityType.Node, name, config);
    }

    @Override
    public void visitCreatedRelationshipLegacyIndex(String name, Map<String, String> config) {
        this.legacyIndexTransactionState.createIndex(IndexEntityType.Relationship, name, config);
    }

    @Override
    public void visitCreatedProcedure(ProcedureDescriptor procedureDescriptor) {
        this.procedureCache.createProcedure(procedureDescriptor);
    }

    @Override
    public void visitDroppedProcedure(ProcedureDescriptor procedureDescriptor) {
        this.procedureCache.dropProcedure(procedureDescriptor);
    }
}

