/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.kvstore.ReadableBuffer;
import org.neo4j.kernel.impl.store.kvstore.WritableBuffer;

public final class BigEndianByteArrayBuffer
implements ReadableBuffer,
WritableBuffer {
    final byte[] buffer;

    static BigEndianByteArrayBuffer buffer(int size) {
        return new BigEndianByteArrayBuffer(size);
    }

    BigEndianByteArrayBuffer(int size) {
        this(new byte[size]);
    }

    public BigEndianByteArrayBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    public String toString() {
        return BigEndianByteArrayBuffer.toString(this.buffer);
    }

    static String toString(byte[] buffer) {
        StringBuilder result = new StringBuilder(buffer.length * 6 + 1).append('[');
        for (byte b : buffer) {
            if (b >= 32 && b < 127) {
                if (b == 39) {
                    result.append("'\\''");
                } else {
                    result.append('\'').append((char)b).append('\'');
                }
            } else {
                result.append("0x");
                if (b < 16) {
                    result.append(0);
                }
                result.append(Integer.toHexString(b & 0xFF));
            }
            result.append(", ");
        }
        if (result.length() > 1) {
            result.setLength(result.length() - 2);
        }
        result.append(']');
        return result.toString();
    }

    static int compare(byte[] key, byte[] searchSpace, int offset) {
        for (int i = 0; i < key.length; ++i) {
            int result = (key[i] & 0xFF) - (searchSpace[offset + i] & 0xFF);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public void clear() {
        this.fill((byte)0);
    }

    public void fill(byte zero) {
        Arrays.fill(this.buffer, zero);
    }

    @Override
    public boolean allZeroes() {
        for (byte b : this.buffer) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    public void dataFrom(ByteBuffer buffer) {
        buffer.get(this.buffer);
    }

    public void dataTo(byte[] target, int targetPos) {
        assert (target.length >= targetPos + this.buffer.length) : "insufficient space";
        System.arraycopy(this.buffer, 0, target, targetPos, this.buffer.length);
    }

    @Override
    public int size() {
        return this.buffer.length;
    }

    @Override
    public byte getByte(int offset) {
        offset = this.checkBounds(offset, 1);
        return this.buffer[offset];
    }

    @Override
    public BigEndianByteArrayBuffer putByte(int offset, byte value) {
        return this.putValue(offset, value, 1);
    }

    @Override
    public short getShort(int offset) {
        offset = this.checkBounds(offset, 2);
        return (short)((0xFF & this.buffer[offset]) << 8 | 0xFF & this.buffer[offset + 1]);
    }

    @Override
    public BigEndianByteArrayBuffer putShort(int offset, short value) {
        return this.putValue(offset, value, 2);
    }

    @Override
    public char getChar(int offset) {
        offset = this.checkBounds(offset, 2);
        return (char)((0xFF & this.buffer[offset]) << 8 | 0xFF & this.buffer[offset + 1]);
    }

    @Override
    public BigEndianByteArrayBuffer putChar(int offset, char value) {
        return this.putValue(offset, value, 2);
    }

    @Override
    public int getInt(int offset) {
        offset = this.checkBounds(offset, 4);
        return (0xFF & this.buffer[offset]) << 24 | (0xFF & this.buffer[offset + 1]) << 16 | (0xFF & this.buffer[offset + 2]) << 8 | 0xFF & this.buffer[offset + 3];
    }

    @Override
    public BigEndianByteArrayBuffer putInt(int offset, int value) {
        return this.putValue(offset, value, 4);
    }

    @Override
    public long getLong(int offset) {
        offset = this.checkBounds(offset, 8);
        return (0xFFL & (long)this.buffer[offset]) << 56 | (0xFFL & (long)this.buffer[offset + 1]) << 48 | (0xFFL & (long)this.buffer[offset + 2]) << 40 | (0xFFL & (long)this.buffer[offset + 3]) << 32 | (0xFFL & (long)this.buffer[offset + 4]) << 24 | (0xFFL & (long)this.buffer[offset + 5]) << 16 | (0xFFL & (long)this.buffer[offset + 6]) << 8 | 0xFFL & (long)this.buffer[offset + 7];
    }

    @Override
    public byte[] get(int offset, byte[] target) {
        System.arraycopy(this.buffer, offset, target, 0, target.length);
        return target;
    }

    @Override
    public int compareTo(byte[] value) {
        return BigEndianByteArrayBuffer.compare(this.buffer, value, 0);
    }

    @Override
    public BigEndianByteArrayBuffer putLong(int offset, long value) {
        return this.putValue(offset, value, 8);
    }

    @Override
    public BigEndianByteArrayBuffer put(int offset, byte[] value) {
        System.arraycopy(value, 0, this.buffer, offset, value.length);
        return this;
    }

    @Override
    public void getFrom(PageCursor cursor) {
        cursor.getBytes(this.buffer);
    }

    private BigEndianByteArrayBuffer putValue(int offset, long value, int size) {
        offset = this.checkBounds(offset, size);
        while (size-- > 0) {
            this.buffer[offset + size] = (byte)(0xFFL & value);
            value >>>= 8;
        }
        return this;
    }

    public void putIntegerAtEnd(long value) throws IOException {
        if (value < 0L) {
            throw new IllegalArgumentException("Negative values not supported.");
        }
        if (this.size() < 8 && Long.numberOfLeadingZeros(value) > 8 * this.size()) {
            throw new IOException(String.format("Cannot write integer value (%d), value capacity = %d", value, this.size()));
        }
        int i = this.buffer.length;
        while (i-- > 0 && value != 0L) {
            this.buffer[i] = (byte)(0xFFL & value);
            value >>>= 8;
        }
    }

    public long getIntegerFromEnd() {
        long value = 0L;
        for (int i = Math.max(0, this.buffer.length - 8); i < this.buffer.length; ++i) {
            value = value << 8 | 0xFFL & (long)this.buffer[i];
        }
        return value;
    }

    public void read(WritableBuffer target) {
        target.put(0, this.buffer);
    }

    private int checkBounds(int offset, int size) {
        if (offset < 0 || offset > this.size() - size) {
            throw new IndexOutOfBoundsException(String.format("offset=%d, buffer size=%d, data item size=%d", offset, this.size(), size));
        }
        return offset;
    }
}

