/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import org.neo4j.helpers.collection.CloseableVisitor;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.state.RecoverableTransaction;

public class LogFileRecoverer
implements Visitor<LogVersionedStoreChannel, Exception> {
    private final LogEntryReader<ReadableLogChannel> logEntryReader;
    private final CloseableVisitor<RecoverableTransaction, Exception> visitor;

    public LogFileRecoverer(LogEntryReader<ReadableLogChannel> logEntryReader, CloseableVisitor<RecoverableTransaction, Exception> visitor) {
        this.logEntryReader = logEntryReader;
        this.visitor = visitor;
    }

    @Override
    public boolean visit(LogVersionedStoreChannel channel) throws Exception {
        final ReadAheadLogChannel recoveredDataChannel = new ReadAheadLogChannel(channel, LogVersionBridge.NO_MORE_CHANNELS);
        try (final PhysicalTransactionCursor<ReadableLogChannel> physicalTransactionCursor = new PhysicalTransactionCursor<ReadableLogChannel>(recoveredDataChannel, this.logEntryReader);){
            RecoverableTransaction recoverableTransaction = new RecoverableTransaction(){

                @Override
                public CommittedTransactionRepresentation representation() {
                    return physicalTransactionCursor.get();
                }

                @Override
                public LogPosition positionAfterTx() {
                    long version = recoveredDataChannel.getVersion();
                    long byteOffset = physicalTransactionCursor.lastKnownGoodPosition();
                    return new LogPosition(version, byteOffset);
                }
            };
            while (physicalTransactionCursor.next() && !this.visitor.visit(recoverableTransaction)) {
            }
            long lastKnownGoodPosition = physicalTransactionCursor.lastKnownGoodPosition();
            if (channel.position() > lastKnownGoodPosition) {
                channel.truncate(lastKnownGoodPosition);
            }
        }
        this.visitor.close();
        return true;
    }
}

