/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.state.DirectionIdentifier;
import org.neo4j.kernel.impl.transaction.state.PropertyDeleter;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.RecordAccessSet;
import org.neo4j.kernel.impl.transaction.state.RelationshipConnection;
import org.neo4j.kernel.impl.transaction.state.RelationshipCreator;
import org.neo4j.kernel.impl.transaction.state.RelationshipGroupGetter;
import org.neo4j.kernel.impl.util.DirectionWrapper;

public class RelationshipDeleter {
    private final RelationshipGroupGetter relGroupGetter;
    private final PropertyDeleter propertyChainDeleter;

    public RelationshipDeleter(RelationshipGroupGetter relGroupGetter, PropertyDeleter propertyChainDeleter) {
        this.relGroupGetter = relGroupGetter;
        this.propertyChainDeleter = propertyChainDeleter;
    }

    public void relDelete(long id, RecordAccessSet recordChanges, Locks.Client locks) {
        RelationshipRecord record = recordChanges.getRelRecords().getOrLoad(id, null).forChangingLinkage();
        this.propertyChainDeleter.deletePropertyChain(record, recordChanges.getPropertyRecords());
        this.disconnectRelationship(record, recordChanges, locks);
        this.updateNodesForDeletedRelationship(record, recordChanges, locks);
        record.setInUse(false);
    }

    private void disconnectRelationship(RelationshipRecord rel, RecordAccessSet recordChangeSet, Locks.Client locks) {
        this.disconnect(rel, RelationshipConnection.START_NEXT, recordChangeSet.getRelRecords(), locks);
        this.disconnect(rel, RelationshipConnection.START_PREV, recordChangeSet.getRelRecords(), locks);
        this.disconnect(rel, RelationshipConnection.END_NEXT, recordChangeSet.getRelRecords(), locks);
        this.disconnect(rel, RelationshipConnection.END_PREV, recordChangeSet.getRelRecords(), locks);
    }

    private void disconnect(RelationshipRecord rel, RelationshipConnection pointer, RecordAccess<Long, RelationshipRecord, Void> relChanges, Locks.Client locks) {
        long otherRelId = pointer.otherSide().get(rel);
        if (otherRelId == (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            return;
        }
        locks.acquireExclusive(ResourceTypes.RELATIONSHIP, otherRelId);
        RelationshipRecord otherRel = relChanges.getOrLoad(otherRelId, null).forChangingLinkage();
        boolean changed = false;
        long newId = pointer.get(rel);
        boolean newIsFirst = pointer.isFirstInChain(rel);
        if (otherRel.getFirstNode() == pointer.compareNode(rel)) {
            pointer.start().set(otherRel, newId, newIsFirst);
            changed = true;
        }
        if (otherRel.getSecondNode() == pointer.compareNode(rel)) {
            pointer.end().set(otherRel, newId, newIsFirst);
            changed = true;
        }
        if (!changed) {
            throw new InvalidRecordException(otherRel + " don't match " + rel);
        }
    }

    private void updateNodesForDeletedRelationship(RelationshipRecord rel, RecordAccessSet recordChanges, Locks.Client locks) {
        RecordAccess.RecordProxy<Long, RelationshipGroupRecord, Integer> groupChange;
        boolean loop;
        RecordAccess.RecordProxy<Long, NodeRecord, Object> startNodeChange = recordChanges.getNodeRecords().getOrLoad(rel.getFirstNode(), null);
        RecordAccess.RecordProxy<Long, NodeRecord, Object> endNodeChange = recordChanges.getNodeRecords().getOrLoad(rel.getSecondNode(), null);
        NodeRecord startNode = recordChanges.getNodeRecords().getOrLoad(rel.getFirstNode(), null).forReadingLinkage();
        NodeRecord endNode = recordChanges.getNodeRecords().getOrLoad(rel.getSecondNode(), null).forReadingLinkage();
        boolean bl = loop = startNode.getId() == endNode.getId();
        if (!startNode.isDense()) {
            if (rel.isFirstInFirstChain()) {
                startNode = startNodeChange.forChangingLinkage();
                startNode.setNextRel(rel.getFirstNextRel());
            }
            this.decrementTotalRelationshipCount(startNode.getId(), rel, startNode.getNextRel(), recordChanges.getRelRecords(), locks);
        } else {
            groupChange = this.relGroupGetter.getRelationshipGroup(startNode, rel.getType(), recordChanges.getRelGroupRecords()).group();
            assert (groupChange != null) : "Relationship group " + rel.getType() + " should have existed here";
            RelationshipGroupRecord group = groupChange.forReadingData();
            DirectionWrapper dir = DirectionIdentifier.wrapDirection(rel, startNode);
            if (rel.isFirstInFirstChain()) {
                group = groupChange.forChangingData();
                dir.setNextRel(group, rel.getFirstNextRel());
                if (this.groupIsEmpty(group)) {
                    this.deleteGroup(startNodeChange, group, recordChanges.getRelGroupRecords());
                }
            }
            this.decrementTotalRelationshipCount(startNode.getId(), rel, dir.getNextRel(group), recordChanges.getRelRecords(), locks);
        }
        if (!endNode.isDense()) {
            if (rel.isFirstInSecondChain()) {
                endNode = endNodeChange.forChangingLinkage();
                endNode.setNextRel(rel.getSecondNextRel());
            }
            if (!loop) {
                this.decrementTotalRelationshipCount(endNode.getId(), rel, endNode.getNextRel(), recordChanges.getRelRecords(), locks);
            }
        } else {
            groupChange = this.relGroupGetter.getRelationshipGroup(endNode, rel.getType(), recordChanges.getRelGroupRecords()).group();
            DirectionWrapper dir = DirectionIdentifier.wrapDirection(rel, endNode);
            assert (groupChange != null || loop) : "Group has been deleted";
            if (groupChange != null) {
                RelationshipGroupRecord group = groupChange.forReadingData();
                if (rel.isFirstInSecondChain()) {
                    group = groupChange.forChangingData();
                    dir.setNextRel(group, rel.getSecondNextRel());
                    if (this.groupIsEmpty(group)) {
                        this.deleteGroup(endNodeChange, group, recordChanges.getRelGroupRecords());
                    }
                }
            }
            if (!loop) {
                this.decrementTotalRelationshipCount(endNode.getId(), rel, dir.getNextRel(groupChange.forChangingData()), recordChanges.getRelRecords(), locks);
            }
        }
    }

    private boolean decrementTotalRelationshipCount(long nodeId, RelationshipRecord rel, long firstRelId, RecordAccess<Long, RelationshipRecord, Void> relRecords, Locks.Client locks) {
        RelationshipRecord firstRel;
        if (firstRelId == (long)Record.NO_PREV_RELATIONSHIP.intValue()) {
            return true;
        }
        boolean firstInChain = this.relIsFirstInChain(nodeId, rel);
        if (!firstInChain) {
            locks.acquireExclusive(ResourceTypes.RELATIONSHIP, firstRelId);
        }
        if (nodeId == (firstRel = relRecords.getOrLoad(firstRelId, null).forChangingLinkage()).getFirstNode()) {
            firstRel.setFirstPrevRel(firstInChain ? (long)(RelationshipCreator.relCount(nodeId, rel) - 1) : (long)(RelationshipCreator.relCount(nodeId, firstRel) - 1));
            firstRel.setFirstInFirstChain(true);
        }
        if (nodeId == firstRel.getSecondNode()) {
            firstRel.setSecondPrevRel(firstInChain ? (long)(RelationshipCreator.relCount(nodeId, rel) - 1) : (long)(RelationshipCreator.relCount(nodeId, firstRel) - 1));
            firstRel.setFirstInSecondChain(true);
        }
        return false;
    }

    private void deleteGroup(RecordAccess.RecordProxy<Long, NodeRecord, Void> nodeChange, RelationshipGroupRecord group, RecordAccess<Long, RelationshipGroupRecord, Integer> relGroupRecords) {
        long previous = group.getPrev();
        long next = group.getNext();
        if (previous == (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            nodeChange.forChangingLinkage().setNextRel(next);
        } else {
            RelationshipGroupRecord previousRecord = relGroupRecords.getOrLoad(previous, null).forChangingLinkage();
            previousRecord.setNext(next);
        }
        if (next != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            RelationshipGroupRecord nextRecord = relGroupRecords.getOrLoad(next, null).forChangingLinkage();
            nextRecord.setPrev(previous);
        }
        group.setInUse(false);
    }

    private boolean groupIsEmpty(RelationshipGroupRecord group) {
        return group.getFirstOut() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() && group.getFirstIn() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() && group.getFirstLoop() == (long)Record.NO_NEXT_RELATIONSHIP.intValue();
    }

    private boolean relIsFirstInChain(long nodeId, RelationshipRecord rel) {
        return nodeId == rel.getFirstNode() && rel.isFirstInFirstChain() || nodeId == rel.getSecondNode() && rel.isFirstInSecondChain();
    }
}

