/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.diffsets;

import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.util.DiffApplyingPrimitiveIntIterator;
import org.neo4j.kernel.impl.util.DiffApplyingRelationshipIterator;
import org.neo4j.kernel.impl.util.diffsets.ReadableRelationshipDiffSets;
import org.neo4j.kernel.impl.util.diffsets.SuperDiffSets;

public class RelationshipDiffSets<T>
extends SuperDiffSets<T, RelationshipIterator>
implements ReadableRelationshipDiffSets<T> {
    private RelationshipVisitor.Home txStateRelationshipHome;

    public RelationshipDiffSets(RelationshipVisitor.Home txStateRelationshipHome) {
        this(txStateRelationshipHome, null, null);
    }

    public RelationshipDiffSets(RelationshipVisitor.Home txStateRelationshipHome, Set<T> addedElements, Set<T> removedElements) {
        super(addedElements, removedElements);
        this.txStateRelationshipHome = txStateRelationshipHome;
    }

    @Override
    public RelationshipIterator augment(RelationshipIterator source) {
        return new DiffApplyingRelationshipIterator(source, this.added(false), this.removed(false), this.txStateRelationshipHome);
    }

    @Override
    public PrimitiveIntIterator augment(PrimitiveIntIterator source) {
        return new DiffApplyingPrimitiveIntIterator(source, this.added(false), this.removed(false));
    }

    @Override
    public RelationshipIterator augmentWithRemovals(RelationshipIterator source) {
        return new DiffApplyingRelationshipIterator(source, Collections.emptySet(), this.removed(false), this.txStateRelationshipHome);
    }

    @Override
    public RelationshipDiffSets<T> filterAdded(Predicate<T> addedFilter) {
        return new RelationshipDiffSets<T>(this.txStateRelationshipHome, IteratorUtil.asSet(Iterables.filter(addedFilter, this.added(false))), IteratorUtil.asSet(this.removed(false)));
    }
}

