/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.info;

import org.neo4j.kernel.info.JvmMetadataRepository;
import org.neo4j.logging.Log;

public class JvmChecker {
    public static final String INCOMPATIBLE_JVM_WARNING = "You are using an unsupported Java runtime. Please use Oracle(R) Java(TM) Runtime Environment 8 or OpenJDK(TM) 8.";
    public static final String INCOMPATIBLE_JVM_VERSION_WARNING = "You are using an unsupported version of the Java runtime. Please use Oracle(R) Java(TM) Runtime Environment 8 or OpenJDK(TM) 8.";
    private final Log log;
    private final JvmMetadataRepository jvmMetadataRepository;

    public JvmChecker(Log log, JvmMetadataRepository jvmMetadataRepository) {
        this.log = log;
        this.jvmMetadataRepository = jvmMetadataRepository;
    }

    public void checkJvmCompatibilityAndIssueWarning() {
        String javaVmName = this.jvmMetadataRepository.getJavaVmName();
        String javaVersion = this.jvmMetadataRepository.getJavaVersion();
        if (!javaVmName.matches("(Java HotSpot\\(TM\\)|OpenJDK) (64-Bit Server|Server|Client) VM")) {
            this.log.warn(INCOMPATIBLE_JVM_WARNING);
        } else if (!javaVersion.matches("^1\\.[8].*")) {
            this.log.warn(INCOMPATIBLE_JVM_VERSION_WARNING);
        }
    }
}

