/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;

public interface Configuration
extends org.neo4j.unsafe.impl.batchimport.staging.Configuration {
    public static final String BAD_FILE_NAME = "bad.log";
    public static final Configuration DEFAULT = new Default();

    public int writeBufferSize();

    public int denseNodeThreshold();

    public int maxNumberOfProcessors();

    public static class Overridden
    extends Configuration.Overridden
    implements Configuration {
        private final Configuration defaults;
        private final Config config;

        public Overridden(Configuration defaults, Config config) {
            super(defaults);
            this.defaults = defaults;
            this.config = config;
        }

        public Overridden(Config config) {
            this(DEFAULT, config);
        }

        @Override
        public int writeBufferSize() {
            return this.defaults.writeBufferSize();
        }

        @Override
        public int denseNodeThreshold() {
            return this.config.get(GraphDatabaseSettings.dense_node_threshold);
        }

        @Override
        public int maxNumberOfProcessors() {
            return this.defaults.maxNumberOfProcessors();
        }

        @Override
        public int movingAverageSize() {
            return this.defaults.movingAverageSize();
        }
    }

    public static class Default
    extends Configuration.Default
    implements Configuration {
        private static final int DEFAULT_PAGE_SIZE = 8192;

        @Override
        public int batchSize() {
            return 10000;
        }

        @Override
        public int writeBufferSize() {
            int averageRecordSize = 40;
            int batchesToBuffer = 1000;
            int maxWriteBufferSize = this.batchSize() * averageRecordSize * batchesToBuffer;
            int writeBufferSize = (int)Math.min((long)maxWriteBufferSize, Runtime.getRuntime().maxMemory() / 5L);
            return this.roundToClosest(writeBufferSize, 245760);
        }

        private int roundToClosest(int value, int divisible) {
            double roughCount = (double)value / (double)divisible;
            int count = (int)Math.round(roughCount);
            return divisible * count;
        }

        @Override
        public int workAheadSize() {
            return 20;
        }

        @Override
        public int denseNodeThreshold() {
            return Integer.parseInt(GraphDatabaseSettings.dense_node_threshold.getDefaultValue());
        }

        @Override
        public int maxNumberOfProcessors() {
            return Runtime.getRuntime().availableProcessors();
        }

        @Override
        public int movingAverageSize() {
            return 100;
        }
    }
}

