/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import java.util.Arrays;

class SameGroupDetector {
    private int[] seen = new int[100];
    private int cursor;

    SameGroupDetector() {
    }

    int collisionWithinSameGroup(int dataIndexA, int groupIdA, int dataIndexB, int groupIdB) {
        if (this.cursor == 0) {
            this.add(dataIndexA, groupIdA);
        }
        int collision = -1;
        for (int i = 0; i < this.cursor; ++i) {
            int dataIndexAtCursor = this.seen[i++];
            int groupIdAtCursor = this.seen[i];
            if (groupIdAtCursor != groupIdB) continue;
            collision = dataIndexAtCursor;
            break;
        }
        this.add(dataIndexB, groupIdB);
        return collision;
    }

    private void add(int dataIndex, int groupId) {
        if (this.cursor == this.seen.length) {
            this.seen = Arrays.copyOf(this.seen, this.seen.length * 2);
        }
        this.seen[this.cursor++] = dataIndex;
        this.seen[this.cursor++] = groupId;
    }

    void reset() {
        this.cursor = 0;
    }
}

