/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

public interface Configuration {
    public static final Configuration DEFAULT = new Default();

    public int batchSize();

    public int workAheadSize();

    public int movingAverageSize();

    public static class Explicit
    implements Configuration {
        private final int batchSize;
        private final int workAheadSize;
        private final int movingAverageSize;

        public Explicit(int batchSize, int workAheadSize, int movingAverageSize) {
            this.batchSize = batchSize;
            this.workAheadSize = workAheadSize;
            this.movingAverageSize = movingAverageSize;
        }

        @Override
        public int batchSize() {
            return this.batchSize;
        }

        @Override
        public int workAheadSize() {
            return this.workAheadSize;
        }

        @Override
        public int movingAverageSize() {
            return this.movingAverageSize;
        }
    }

    public static class Overridden
    implements Configuration {
        private final Configuration defaults;

        public Overridden(Configuration defaults) {
            this.defaults = defaults;
        }

        @Override
        public int batchSize() {
            return this.defaults.batchSize();
        }

        @Override
        public int workAheadSize() {
            return this.defaults.workAheadSize();
        }

        @Override
        public int movingAverageSize() {
            return this.defaults.movingAverageSize();
        }
    }

    public static class Default
    implements Configuration {
        @Override
        public int batchSize() {
            return 20000;
        }

        @Override
        public int workAheadSize() {
            return 20;
        }

        @Override
        public int movingAverageSize() {
            return 1000;
        }
    }
}

