/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.function.Supplier;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.kernel.api.AccessMode;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.legacyindex.AutoIndexing;
import org.neo4j.kernel.impl.coreapi.CoreAPIAvailabilityGuard;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.QuerySession;
import org.neo4j.kernel.impl.store.StoreId;

class ProcedureGDBFacadeSPI
implements GraphDatabaseFacade.SPI {
    private final KernelTransaction transaction;
    private final Supplier<QueryExecutionEngine> queryExecutor;
    private final DependencyResolver resolver;
    private final AutoIndexing autoIndexing;
    private final Supplier<StoreId> storeId;
    private final CoreAPIAvailabilityGuard availability;
    private final ThrowingFunction<URL, URL, URLAccessValidationError> urlValidator;
    private final File storeDir;

    public ProcedureGDBFacadeSPI(KernelTransaction transaction, Supplier<QueryExecutionEngine> queryExecutor, File storeDir, DependencyResolver resolver, AutoIndexing autoIndexing, Supplier<StoreId> storeId, CoreAPIAvailabilityGuard availability, ThrowingFunction<URL, URL, URLAccessValidationError> urlValidator) {
        this.transaction = transaction;
        this.queryExecutor = queryExecutor;
        this.storeDir = storeDir;
        this.resolver = resolver;
        this.autoIndexing = autoIndexing;
        this.storeId = storeId;
        this.availability = availability;
        this.urlValidator = urlValidator;
    }

    @Override
    public boolean databaseIsAvailable(long timeout) {
        return this.availability.isAvailable(timeout);
    }

    @Override
    public DependencyResolver resolver() {
        return this.resolver;
    }

    @Override
    public StoreId storeId() {
        return this.storeId.get();
    }

    @Override
    public File storeDir() {
        return this.storeDir;
    }

    @Override
    public String name() {
        return "ProcedureGraphDatabaseService";
    }

    @Override
    public KernelTransaction currentTransaction() {
        this.availability.assertDatabaseAvailable();
        return this.transaction;
    }

    @Override
    public boolean isInOpenTransaction() {
        return this.transaction.isOpen();
    }

    @Override
    public Statement currentStatement() {
        return this.transaction.acquireStatement();
    }

    @Override
    public Result executeQuery(String query, Map<String, Object> parameters, QuerySession querySession) {
        try {
            this.availability.assertDatabaseAvailable();
            return this.queryExecutor.get().executeQuery(query, parameters, querySession);
        }
        catch (QueryExecutionKernelException e) {
            throw e.asUserException();
        }
    }

    @Override
    public AutoIndexing autoIndexing() {
        return this.autoIndexing;
    }

    @Override
    public void registerKernelEventHandler(KernelEventHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unregisterKernelEventHandler(KernelEventHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL validateURLAccess(URL url) throws URLAccessValidationError {
        return (URL)this.urlValidator.apply((Object)url);
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public KernelTransaction beginTransaction(KernelTransaction.Type type, AccessMode accessMode) {
        throw new UnsupportedOperationException();
    }
}

