/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.InlineNodeLabels;
import org.neo4j.kernel.impl.store.LabelIdArray;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;

public class DynamicNodeLabels
implements NodeLabels {
    private final long labelField;
    private final NodeRecord node;

    public DynamicNodeLabels(long labelField, NodeRecord node) {
        this.labelField = labelField;
        this.node = node;
    }

    @Override
    public long[] get(NodeStore nodeStore) {
        return DynamicNodeLabels.get(this.node, nodeStore);
    }

    public static long[] get(NodeRecord node, NodeStore nodeStore) {
        if (node.isLight()) {
            nodeStore.ensureHeavy(node, NodeLabelsField.firstDynamicLabelRecordId(node.getLabelField()));
        }
        return DynamicNodeLabels.getDynamicLabelsArray(node.getUsedDynamicLabelRecords(), nodeStore.getDynamicLabelStore());
    }

    @Override
    public long[] getIfLoaded() {
        if (this.node.isLight()) {
            return null;
        }
        return LabelIdArray.stripNodeId((long[])DynamicArrayStore.getRightArray(AbstractDynamicStore.readFullByteArrayFromHeavyRecords(this.node.getUsedDynamicLabelRecords(), PropertyType.ARRAY)));
    }

    @Override
    public Collection<DynamicRecord> put(long[] labelIds, NodeStore nodeStore, DynamicRecordAllocator allocator) {
        Arrays.sort(labelIds);
        return DynamicNodeLabels.putSorted(this.node, labelIds, nodeStore, allocator);
    }

    public static Collection<DynamicRecord> putSorted(NodeRecord node, long[] labelIds, NodeStore nodeStore, DynamicRecordAllocator allocator) {
        long existingLabelsField = node.getLabelField();
        long existingLabelsBits = NodeLabelsField.parseLabelsBody(existingLabelsField);
        Collection<DynamicRecord> changedDynamicRecords = node.getDynamicLabelRecords();
        long labelField = node.getLabelField();
        if (NodeLabelsField.fieldPointsToDynamicRecordOfLabels(labelField)) {
            nodeStore.ensureHeavy(node, existingLabelsBits);
            changedDynamicRecords = node.getDynamicLabelRecords();
            DynamicNodeLabels.setNotInUse(changedDynamicRecords);
        }
        if (!InlineNodeLabels.tryInlineInNodeRecord(node, labelIds, changedDynamicRecords)) {
            Iterator<DynamicRecord> recycledRecords = changedDynamicRecords.iterator();
            Collection<DynamicRecord> allocatedRecords = DynamicNodeLabels.allocateRecordsForDynamicLabels(node.getId(), labelIds, recycledRecords, allocator);
            while (recycledRecords.hasNext()) {
                DynamicRecord removedRecord = recycledRecords.next();
                removedRecord.setInUse(false);
                allocatedRecords.add(removedRecord);
            }
            node.setLabelField(DynamicNodeLabels.dynamicPointer(allocatedRecords), allocatedRecords);
            changedDynamicRecords = allocatedRecords;
        }
        return changedDynamicRecords;
    }

    @Override
    public Collection<DynamicRecord> add(long labelId, NodeStore nodeStore, DynamicRecordAllocator allocator) {
        nodeStore.ensureHeavy(this.node, NodeLabelsField.firstDynamicLabelRecordId(this.labelField));
        Collection<DynamicRecord> existingRecords = this.node.getDynamicLabelRecords();
        long[] existingLabelIds = DynamicNodeLabels.getDynamicLabelsArray(existingRecords, nodeStore.getDynamicLabelStore());
        long[] newLabelIds = LabelIdArray.concatAndSort(existingLabelIds, labelId);
        Collection<DynamicRecord> changedDynamicRecords = DynamicNodeLabels.allocateRecordsForDynamicLabels(this.node.getId(), newLabelIds, existingRecords.iterator(), allocator);
        this.node.setLabelField(DynamicNodeLabels.dynamicPointer(changedDynamicRecords), changedDynamicRecords);
        return changedDynamicRecords;
    }

    @Override
    public Collection<DynamicRecord> remove(long labelId, NodeStore nodeStore) {
        nodeStore.ensureHeavy(this.node, NodeLabelsField.firstDynamicLabelRecordId(this.labelField));
        long[] existingLabelIds = DynamicNodeLabels.getDynamicLabelsArray(this.node.getUsedDynamicLabelRecords(), nodeStore.getDynamicLabelStore());
        long[] newLabelIds = LabelIdArray.filter(existingLabelIds, labelId);
        Collection<DynamicRecord> existingRecords = this.node.getDynamicLabelRecords();
        if (InlineNodeLabels.tryInlineInNodeRecord(this.node, newLabelIds, existingRecords)) {
            DynamicNodeLabels.setNotInUse(existingRecords);
        } else {
            Collection<DynamicRecord> newRecords = DynamicNodeLabels.allocateRecordsForDynamicLabels(this.node.getId(), newLabelIds, existingRecords.iterator(), nodeStore.getDynamicLabelStore());
            this.node.setLabelField(DynamicNodeLabels.dynamicPointer(newRecords), existingRecords);
            if (!newRecords.equals(existingRecords)) {
                for (DynamicRecord record : existingRecords) {
                    if (newRecords.contains(record)) continue;
                    record.setInUse(false);
                }
            }
        }
        return existingRecords;
    }

    public long getFirstDynamicRecordId() {
        return NodeLabelsField.firstDynamicLabelRecordId(this.labelField);
    }

    public static long dynamicPointer(Collection<DynamicRecord> newRecords) {
        return 0x8000000000L | ((DynamicRecord)IteratorUtil.first(newRecords)).getId();
    }

    private static void setNotInUse(Collection<DynamicRecord> changedDynamicRecords) {
        for (DynamicRecord record : changedDynamicRecords) {
            record.setInUse(false);
        }
    }

    @Override
    public boolean isInlined() {
        return false;
    }

    public String toString() {
        if (this.node.isLight()) {
            return String.format("Dynamic(id:%d)", NodeLabelsField.firstDynamicLabelRecordId(this.node.getLabelField()));
        }
        return String.format("Dynamic(id:%d,[%s])", NodeLabelsField.firstDynamicLabelRecordId(this.node.getLabelField()), Arrays.toString(DynamicNodeLabels.getDynamicLabelsArrayFromHeavyRecords(this.node.getUsedDynamicLabelRecords())));
    }

    public static Collection<DynamicRecord> allocateRecordsForDynamicLabels(long nodeId, long[] labels, Iterator<DynamicRecord> useFirst, AbstractDynamicStore dynamicLabelStore) {
        return DynamicNodeLabels.allocateRecordsForDynamicLabels(nodeId, labels, useFirst, (DynamicRecordAllocator)dynamicLabelStore);
    }

    public static Collection<DynamicRecord> allocateRecordsForDynamicLabels(long nodeId, long[] labels, Iterator<DynamicRecord> useFirst, DynamicRecordAllocator allocator) {
        long[] storedLongs = LabelIdArray.prependNodeId(nodeId, labels);
        ArrayList<DynamicRecord> records = new ArrayList<DynamicRecord>();
        DynamicArrayStore.allocateRecords(records, storedLongs, useFirst, allocator);
        return records;
    }

    public static long[] getDynamicLabelsArray(Iterable<DynamicRecord> records, AbstractDynamicStore dynamicLabelStore) {
        long[] storedLongs = (long[])DynamicArrayStore.getRightArray(dynamicLabelStore.readFullByteArray(records, PropertyType.ARRAY));
        return LabelIdArray.stripNodeId(storedLongs);
    }

    public static long[] getDynamicLabelsArrayFromHeavyRecords(Iterable<DynamicRecord> records) {
        long[] storedLongs = (long[])DynamicArrayStore.getRightArray(AbstractDynamicStore.readFullByteArrayFromHeavyRecords(records, PropertyType.ARRAY));
        return LabelIdArray.stripNodeId(storedLongs);
    }

    public static Pair<Long, long[]> getDynamicLabelsArrayAndOwner(Iterable<DynamicRecord> records, AbstractDynamicStore dynamicLabelStore) {
        long[] storedLongs = (long[])DynamicArrayStore.getRightArray(dynamicLabelStore.readFullByteArray(records, PropertyType.ARRAY));
        return Pair.of((Object)storedLongs[0], (Object)LabelIdArray.stripNodeId(storedLongs));
    }
}

