/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.lowlimit;

import java.io.IOException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.store.format.BaseOneByteHeaderRecordFormat;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;

class NodeRecordFormatV2_0
extends BaseOneByteHeaderRecordFormat<NodeRecord> {
    NodeRecordFormatV2_0() {
        super(NodeRecordFormatV2_0.fixedRecordSize(14), 0, 1);
    }

    @Override
    public NodeRecord newRecord() {
        return new NodeRecord(-1L);
    }

    @Override
    public void read(NodeRecord record, PageCursor cursor, RecordLoad mode, int recordSize, PagedFile storeFile) throws IOException {
        long headerByte = cursor.getByte();
        boolean inUse = this.isInUse((byte)headerByte);
        if (mode.shouldLoad(inUse)) {
            long nextRel = cursor.getUnsignedInt();
            long nextProp = cursor.getUnsignedInt();
            long relModifier = (headerByte & 0xEL) << 31;
            long propModifier = (headerByte & 0xF0L) << 28;
            long lsbLabels = cursor.getUnsignedInt();
            long hsbLabels = cursor.getByte() & 0xFF;
            long labels = lsbLabels | hsbLabels << 32;
            record.initialize(inUse, NodeRecordFormatV2_0.longFromIntAndMod(nextProp, propModifier), false, NodeRecordFormatV2_0.longFromIntAndMod(nextRel, relModifier), labels);
        }
    }

    @Override
    public void write(NodeRecord record, PageCursor cursor, int recordSize, PagedFile storeFile) throws IOException {
        throw new UnsupportedOperationException();
    }
}

