/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

public enum IdType {
    NODE(35, false),
    RELATIONSHIP(35, false),
    PROPERTY(36, true),
    STRING_BLOCK(36, true),
    ARRAY_BLOCK(36, true),
    PROPERTY_KEY_TOKEN(false),
    PROPERTY_KEY_TOKEN_NAME(false),
    RELATIONSHIP_TYPE_TOKEN(16, false),
    RELATIONSHIP_TYPE_TOKEN_NAME(false),
    LABEL_TOKEN(false),
    LABEL_TOKEN_NAME(false),
    NEOSTORE_BLOCK(false),
    SCHEMA(35, false),
    NODE_LABELS(35, true),
    RELATIONSHIP_GROUP(35, false);

    private final long max;
    private final boolean allowAggressiveReuse;

    private IdType(boolean allowAggressiveReuse) {
        this(32, allowAggressiveReuse);
    }

    private IdType(int bits, boolean allowAggressiveReuse) {
        this.allowAggressiveReuse = allowAggressiveReuse;
        this.max = (long)Math.pow(2.0, bits) - 1L;
    }

    public long getMaxValue() {
        return this.max;
    }

    public boolean allowAggressiveReuse() {
        return this.allowAggressiveReuse;
    }

    public int getGrabSize() {
        return this.allowAggressiveReuse ? 50000 : 1024;
    }
}

