/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.util.HashMap;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class DirectRecordStoreMigrator {
    private final PageCache pageCache;
    private final FileSystemAbstraction fs;
    private final Config config;

    public DirectRecordStoreMigrator(PageCache pageCache, FileSystemAbstraction fs, Config config) {
        this.pageCache = pageCache;
        this.fs = fs;
        this.config = config;
    }

    public void migrate(File fromStoreDir, RecordFormats fromFormat, File toStoreDir, RecordFormats toFormat, StoreType[] types, StoreType ... additionalTypesToOpen) {
        StoreType[] storesToOpen = ArrayUtil.concat(types, additionalTypesToOpen);
        try (NeoStores fromStores = new StoreFactory(fromStoreDir, this.config, new DefaultIdGeneratorFactory(this.fs), this.pageCache, this.fs, (LogProvider)NullLogProvider.getInstance(), fromFormat).openNeoStores(true, storesToOpen);
             NeoStores toStores = new StoreFactory(toStoreDir, this.withPersistedStoreHeadersAsConfigFrom(fromStores, storesToOpen), new DefaultIdGeneratorFactory(this.fs), this.pageCache, this.fs, (LogProvider)NullLogProvider.getInstance(), toFormat).openNeoStores(true, storesToOpen);){
            for (StoreType type : types) {
                if (!type.isRecordStore()) continue;
                this.migrate(fromStores.getRecordStore(type), toStores.getRecordStore(type));
            }
        }
    }

    private <RECORD extends AbstractBaseRecord> void migrate(RecordStore<RECORD> from, RecordStore<RECORD> to) {
        to.setHighestPossibleIdInUse(from.getHighestPossibleIdInUse());
        RecordCursor<RECORD> cursor = from.newRecordCursor(from.newRecord());
        long highId = from.getHighId();
        from.placeRecordCursor(from.getNumberOfReservedLowIds(), cursor, RecordLoad.CHECK);
        for (long id = (long)from.getNumberOfReservedLowIds(); id < highId; ++id) {
            if (!cursor.next(id)) continue;
            AbstractBaseRecord record = (AbstractBaseRecord)cursor.get();
            to.prepareForCommit(record);
            to.updateRecord(record);
        }
    }

    private Config withPersistedStoreHeadersAsConfigFrom(NeoStores legacyStores, StoreType[] types) {
        HashMap<String, String> config = new HashMap<String, String>(this.config.getParams());
        if (ArrayUtil.contains(types, StoreType.RELATIONSHIP_GROUP)) {
            config.put(GraphDatabaseSettings.dense_node_threshold.name(), String.valueOf(legacyStores.getRelationshipGroupStore().getStoreHeaderInt()));
        }
        if (ArrayUtil.contains(types, StoreType.PROPERTY)) {
            config.put(GraphDatabaseSettings.array_block_size.name(), String.valueOf(legacyStores.getPropertyStore().getArrayStore().getRecordDataSize()));
            config.put(GraphDatabaseSettings.string_block_size.name(), String.valueOf(legacyStores.getPropertyStore().getStringStore().getRecordDataSize()));
        }
        if (ArrayUtil.contains(types, StoreType.NODE_LABEL)) {
            config.put(GraphDatabaseSettings.label_block_size.name(), String.valueOf(legacyStores.getNodeStore().getDynamicLabelStore().getRecordDataSize()));
        }
        return new Config(config);
    }
}

