/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.AbstractSchemaRule;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.transaction.command.BaseCommandReader;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.CommandReading;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class PhysicalLogCommandReaderV2_0
extends BaseCommandReader {
    @Override
    protected Command read(byte commandType, ReadableChannel channel) throws IOException {
        switch (commandType) {
            case 1: {
                return this.visitNodeCommand(channel);
            }
            case 2: {
                return this.visitPropertyCommand(channel);
            }
            case 5: {
                return this.visitPropertyKeyTokenCommand(channel);
            }
            case 3: {
                return this.visitRelationshipCommand(channel);
            }
            case 4: {
                return this.visitRelationshipTypeTokenCommand(channel);
            }
            case 8: {
                return this.visitLabelTokenCommand(channel);
            }
            case 6: {
                return this.visitNeoStoreCommand(channel);
            }
            case 7: {
                return this.visitSchemaRuleCommand(channel);
            }
        }
        throw this.unknownCommandType(commandType, channel);
    }

    private Command visitNodeCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        NodeRecord before = this.readNodeRecord(id, channel);
        if (before == null) {
            return null;
        }
        NodeRecord after = this.readNodeRecord(id, channel);
        if (after == null) {
            return null;
        }
        if (!before.inUse() && after.inUse()) {
            after.setCreated();
        }
        return new Command.NodeCommand(before, after);
    }

    private Command visitRelationshipCommand(ReadableChannel channel) throws IOException {
        RelationshipRecord record;
        long id = channel.getLong();
        byte inUseFlag = channel.get();
        boolean inUse = false;
        if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
        } else if ((inUseFlag & Record.IN_USE.byteValue()) != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + inUseFlag);
        }
        if (inUse) {
            record = new RelationshipRecord(id, channel.getLong(), channel.getLong(), channel.getInt());
            record.setInUse(inUse);
            record.setFirstPrevRel(channel.getLong());
            record.setFirstNextRel(channel.getLong());
            record.setSecondPrevRel(channel.getLong());
            record.setSecondNextRel(channel.getLong());
            record.setNextProp(channel.getLong());
            record.setFirstInFirstChain(record.getFirstPrevRel() == (long)Record.NO_PREV_RELATIONSHIP.intValue());
            record.setFirstInSecondChain(record.getSecondPrevRel() == (long)Record.NO_PREV_RELATIONSHIP.intValue());
        } else {
            record = new RelationshipRecord(id);
        }
        return new Command.RelationshipCommand(null, record);
    }

    protected Command visitPropertyCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        PropertyRecord before = this.readPropertyRecord(id, channel);
        if (before == null) {
            return null;
        }
        PropertyRecord after = this.readPropertyRecord(id, channel);
        if (after == null) {
            return null;
        }
        return new Command.PropertyCommand(before, after);
    }

    private Command visitRelationshipTypeTokenCommand(ReadableChannel channel) throws IOException {
        int id = channel.getInt();
        byte inUseFlag = channel.get();
        boolean inUse = false;
        if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
        } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + inUseFlag);
        }
        RelationshipTypeTokenRecord record = new RelationshipTypeTokenRecord(id);
        record.setInUse(inUse);
        record.setNameId(channel.getInt());
        int nrTypeRecords = channel.getInt();
        for (int i = 0; i < nrTypeRecords; ++i) {
            DynamicRecord dr = this.readDynamicRecord(channel);
            if (dr == null) {
                return null;
            }
            record.addNameRecord(dr);
        }
        return new Command.RelationshipTypeTokenCommand(null, record);
    }

    private Command visitLabelTokenCommand(ReadableChannel channel) throws IOException {
        int id = channel.getInt();
        byte inUseFlag = channel.get();
        boolean inUse = false;
        if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
        } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + inUseFlag);
        }
        LabelTokenRecord record = new LabelTokenRecord(id);
        record.setInUse(inUse);
        record.setNameId(channel.getInt());
        int nrTypeRecords = channel.getInt();
        for (int i = 0; i < nrTypeRecords; ++i) {
            DynamicRecord dr = this.readDynamicRecord(channel);
            if (dr == null) {
                return null;
            }
            record.addNameRecord(dr);
        }
        return new Command.LabelTokenCommand(null, record);
    }

    private Command visitPropertyKeyTokenCommand(ReadableChannel channel) throws IOException {
        int id = channel.getInt();
        byte inUseFlag = channel.get();
        boolean inUse = false;
        if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
        } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + inUseFlag);
        }
        PropertyKeyTokenRecord record = new PropertyKeyTokenRecord(id);
        record.setInUse(inUse);
        record.setPropertyCount(channel.getInt());
        record.setNameId(channel.getInt());
        int recordNr = this.readDynamicRecords(channel, record, CommandReading.PROPERTY_INDEX_DYNAMIC_RECORD_ADDER);
        if (recordNr == -1) {
            return null;
        }
        return new Command.PropertyKeyTokenCommand(null, record);
    }

    private Command visitSchemaRuleCommand(ReadableChannel channel) throws IOException {
        ArrayList<DynamicRecord> recordsBefore = new ArrayList<DynamicRecord>();
        this.readDynamicRecords(channel, recordsBefore, CommandReading.COLLECTION_DYNAMIC_RECORD_ADDER);
        ArrayList<DynamicRecord> recordsAfter = new ArrayList<DynamicRecord>();
        this.readDynamicRecords(channel, recordsAfter, CommandReading.COLLECTION_DYNAMIC_RECORD_ADDER);
        byte isCreated = channel.get();
        if (1 == isCreated) {
            for (DynamicRecord record : recordsAfter) {
                record.setCreated();
            }
        }
        channel.getLong();
        SchemaRule rule = ((DynamicRecord)IteratorUtil.first(recordsAfter)).inUse() ? this.readSchemaRule(recordsAfter) : this.readSchemaRule(recordsBefore);
        return new Command.SchemaRuleCommand(recordsBefore, recordsAfter, rule);
    }

    private Command visitNeoStoreCommand(ReadableChannel channel) throws IOException {
        long nextProp = channel.getLong();
        NeoStoreRecord record = new NeoStoreRecord();
        record.setNextProp(nextProp);
        return new Command.NeoStoreCommand(null, record);
    }

    private NodeRecord readNodeRecord(long id, ReadableChannel channel) throws IOException {
        NodeRecord record;
        byte inUseFlag = channel.get();
        boolean inUse = false;
        if (inUseFlag == Record.IN_USE.byteValue()) {
            inUse = true;
        } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + inUseFlag);
        }
        if (inUse) {
            record = new NodeRecord(id, false, channel.getLong(), channel.getLong());
            long labelField = channel.getLong();
            ArrayList<DynamicRecord> dynamicLabelRecords = new ArrayList<DynamicRecord>();
            this.readDynamicRecords(channel, dynamicLabelRecords, CommandReading.COLLECTION_DYNAMIC_RECORD_ADDER);
            record.setLabelField(labelField, dynamicLabelRecords);
        } else {
            record = new NodeRecord(id);
        }
        record.setInUse(inUse);
        return record;
    }

    private DynamicRecord readDynamicRecord(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        assert (id >= 0L && id <= 0xFFFFFFFFFL) : id + " is not a valid dynamic record id";
        int type = channel.getInt();
        byte inUseFlag = channel.get();
        boolean inUse = (inUseFlag & Record.IN_USE.byteValue()) != 0;
        DynamicRecord record = new DynamicRecord(id);
        record.setInUse(inUse, type);
        if (inUse) {
            record.setStartRecord((inUseFlag & Record.FIRST_IN_CHAIN.byteValue()) != 0);
            int nrOfBytes = channel.getInt();
            assert (nrOfBytes >= 0 && nrOfBytes < 0xFFFFFF) : nrOfBytes + " is not valid for a number of bytes field of " + "a dynamic record";
            long nextBlock = channel.getLong();
            assert (nextBlock >= 0L && nextBlock <= 0x800000000L || nextBlock == (long)Record.NO_NEXT_BLOCK.intValue()) : nextBlock + " is not valid for a next record field of " + "a dynamic record";
            record.setNextBlock(nextBlock);
            byte[] data = new byte[nrOfBytes];
            channel.get(data, nrOfBytes);
            record.setData(data);
        }
        return record;
    }

    private <T> int readDynamicRecords(ReadableChannel channel, T target, CommandReading.DynamicRecordAdder<T> adder) throws IOException {
        int numberOfRecords = channel.getInt();
        assert (numberOfRecords >= 0);
        int records = numberOfRecords;
        while (records-- > 0) {
            DynamicRecord read = this.readDynamicRecord(channel);
            if (read == null) {
                return -1;
            }
            adder.add(target, read);
        }
        return numberOfRecords;
    }

    private PropertyRecord readPropertyRecord(long id, ReadableChannel channel) throws IOException {
        long primitiveId;
        PropertyRecord record = new PropertyRecord(id);
        byte inUseFlag = channel.get();
        long nextProp = channel.getLong();
        long prevProp = channel.getLong();
        record.setNextProp(nextProp);
        record.setPrevProp(prevProp);
        boolean inUse = false;
        if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
        }
        boolean nodeProperty = true;
        if ((inUseFlag & Record.REL_PROPERTY.byteValue()) == Record.REL_PROPERTY.byteValue()) {
            nodeProperty = false;
        }
        if ((primitiveId = channel.getLong()) != -1L && nodeProperty) {
            record.setNodeId(primitiveId);
        } else if (primitiveId != -1L) {
            record.setRelId(primitiveId);
        }
        int nrPropBlocks = channel.get();
        assert (nrPropBlocks >= 0);
        if (nrPropBlocks > 0) {
            record.setInUse(true);
        }
        while (nrPropBlocks-- > 0) {
            PropertyBlock block = this.readPropertyBlock(channel);
            if (block == null) {
                return null;
            }
            record.addPropertyBlock(block);
        }
        if (this.readDynamicRecords(channel, record, CommandReading.PROPERTY_DELETED_DYNAMIC_RECORD_ADDER) == -1) {
            return null;
        }
        if (inUse && !record.inUse() || !inUse && record.inUse()) {
            throw new IllegalStateException("Weird, inUse was read in as " + inUse + " but the record is " + record);
        }
        return record;
    }

    private PropertyBlock readPropertyBlock(ReadableChannel channel) throws IOException {
        PropertyBlock toReturn = new PropertyBlock();
        byte blockSize = channel.get();
        assert (blockSize > 0 && blockSize % 8 == 0) : blockSize + " is not a valid block size value";
        long[] blocks = this.readLongs(channel, blockSize / 8);
        assert (blocks.length == blockSize / 8) : blocks.length + " longs were read in while i asked for what corresponds to " + blockSize;
        assert (PropertyType.getPropertyType(blocks[0], false).calculateNumberOfBlocksUsed(blocks[0]) == blocks.length) : blocks.length + " is not a valid number of blocks for type " + (Object)((Object)PropertyType.getPropertyType(blocks[0], false));
        toReturn.setValueBlocks(blocks);
        if (this.readDynamicRecords(channel, toReturn, CommandReading.PROPERTY_BLOCK_DYNAMIC_RECORD_ADDER) == -1) {
            return null;
        }
        return toReturn;
    }

    private long[] readLongs(ReadableChannel channel, int count) throws IOException {
        long[] result = new long[count];
        for (int i = 0; i < count; ++i) {
            result[i] = channel.getLong();
        }
        return result;
    }

    private SchemaRule readSchemaRule(Collection<DynamicRecord> recordsBefore) {
        SchemaRule rule;
        assert (((DynamicRecord)IteratorUtil.first(recordsBefore)).inUse()) : "Asked to deserialize schema records that were not in use.";
        ByteBuffer deserialized = AbstractDynamicStore.concatData(recordsBefore, new byte[100]);
        try {
            rule = AbstractSchemaRule.deserialize(((DynamicRecord)IteratorUtil.first(recordsBefore)).getId(), deserialized);
        }
        catch (MalformedSchemaRuleException e) {
            throw Exceptions.launderedException(e);
        }
        return rule;
    }
}

