/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParsersV1_9;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParsersV2_0;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParsersV2_1;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParsersV2_2;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParsersV2_2_4;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParsersV2_3;

public enum LogEntryVersion {
    V1_9(0, LogEntryParsersV1_9.class, 2),
    V2_0(0, LogEntryParsersV2_0.class, 3),
    V2_1(-1, LogEntryParsersV2_1.class),
    V2_2(-2, LogEntryParsersV2_2.class),
    V2_2_4(-4, LogEntryParsersV2_2_4.class),
    V2_3(-5, LogEntryParsersV2_3.class),
    V3_0(-6, LogEntryParsersV2_3.class);

    public static final LogEntryVersion CURRENT;
    public static final byte NO_PARTICULAR_LOG_HEADER_FORMAT_VERSION = -1;
    private static final LogEntryVersion[] ALL;
    private static final LogEntryVersion[] NEGATIVE;
    private static final LogEntryVersion[] POSITIVE;
    private final byte version;
    private final LogEntryParser<LogEntry>[] entryTypes;
    private final byte logHeaderFormatVersion;
    private LogEntryVersion nextWithSameLogEntryVersion;

    private LogEntryVersion(int version, Class<? extends Enum<? extends LogEntryParser<? extends LogEntry>>> cls) {
        this(version, cls, -1);
    }

    private LogEntryVersion(int version, Class<? extends Enum<? extends LogEntryParser<? extends LogEntry>>> cls, int logHeaderFormatVersion) {
        this.logHeaderFormatVersion = LogEntryVersion.safeCastToByte(logHeaderFormatVersion);
        this.entryTypes = new LogEntryParser[LogEntryVersion.highestCode(cls) + 1];
        for (Enum<? extends LogEntryParser<? extends LogEntry>> parser : cls.getEnumConstants()) {
            LogEntryParser candidate;
            this.entryTypes[candidate.byteCode()] = candidate = (LogEntryParser)((Object)parser);
        }
        this.version = LogEntryVersion.safeCastToByte(version);
    }

    public byte byteCode() {
        return this.version;
    }

    public LogEntryParser<LogEntry> entryParser(byte type) {
        LogEntryParser<LogEntry> candidate;
        LogEntryParser<LogEntry> logEntryParser = candidate = type >= 0 && type < this.entryTypes.length ? this.entryTypes[type] : null;
        if (candidate == null) {
            throw new IllegalArgumentException("Unknown entry type " + type + " for version " + this.version);
        }
        return candidate;
    }

    public static LogEntryVersion byVersion(byte version, byte logHeaderFormatVersion) {
        LogEntryVersion candidate;
        byte flattenedVersion;
        LogEntryVersion[] from;
        if (version < 0) {
            from = NEGATIVE;
            flattenedVersion = -version;
        } else {
            from = POSITIVE;
            flattenedVersion = version;
        }
        LogEntryVersion logEntryVersion = candidate = flattenedVersion < from.length ? from[flattenedVersion] : null;
        while (candidate != null) {
            if (candidate.nextWithSameLogEntryVersion == null || candidate.logHeaderFormatVersion == logHeaderFormatVersion) {
                return candidate;
            }
            candidate = candidate.nextWithSameLogEntryVersion;
        }
        throw new IllegalArgumentException("Unrecognized log entry version " + version + " and logHeaderFormatVersion " + logHeaderFormatVersion);
    }

    @Deprecated
    public byte logHeaderFormatVersion() {
        return this.logHeaderFormatVersion;
    }

    private static void put(LogEntryVersion[] array, int index, LogEntryVersion version) {
        version.nextWithSameLogEntryVersion = array[index];
        array[index] = version;
    }

    private static byte safeCastToByte(int value) {
        boolean reversed = false;
        if (value < 0) {
            value ^= 0xFFFFFFFF;
            reversed = true;
        }
        if ((value & 0xFFFFFF00) != 0) {
            throw new Error(String.format("Bad version %d, must be contained within one byte", value));
        }
        return (byte)(reversed ? ~value : value);
    }

    private static int highestCode(Class<? extends Enum<? extends LogEntryParser<? extends LogEntry>>> cls) {
        int highestCode = 0;
        for (Enum<? extends LogEntryParser<? extends LogEntry>> parser : cls.getEnumConstants()) {
            LogEntryParser candidate = (LogEntryParser)((Object)parser);
            highestCode = Math.max(highestCode, candidate.byteCode());
        }
        return highestCode;
    }

    static {
        CURRENT = V3_0;
        ALL = LogEntryVersion.values();
        NEGATIVE = new LogEntryVersion[ALL.length + 1];
        POSITIVE = new LogEntryVersion[ALL.length];
        for (LogEntryVersion version : ALL) {
            if (version.byteCode() < 0) {
                LogEntryVersion.put(NEGATIVE, -version.byteCode(), version);
                continue;
            }
            LogEntryVersion.put(POSITIVE, version.byteCode(), version);
        }
    }
}

