/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Supplier;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PathExpanders;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.impl.StandardExpander;
import org.neo4j.graphdb.traversal.BranchOrderingPolicies;
import org.neo4j.graphdb.traversal.BranchOrderingPolicy;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.InitialBranchState;
import org.neo4j.graphdb.traversal.PathEvaluator;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.kernel.Uniqueness;
import org.neo4j.kernel.impl.traversal.DefaultTraverser;
import org.neo4j.kernel.impl.traversal.MonoDirectionalTraverserIterator;
import org.neo4j.kernel.impl.traversal.MultiEvaluator;
import org.neo4j.kernel.impl.traversal.SortingTraverserIterator;
import org.neo4j.kernel.impl.traversal.TraverserIterator;

public final class MonoDirectionalTraversalDescription
implements TraversalDescription {
    static final Supplier<Resource> NO_STATEMENT = () -> Resource.EMPTY;
    final PathExpander expander;
    final InitialBranchState initialState;
    final Supplier<? extends Resource> statementSupplier;
    final UniquenessFactory uniqueness;
    final Object uniquenessParameter;
    final PathEvaluator evaluator;
    final BranchOrderingPolicy branchOrdering;
    final Comparator<? super Path> sorting;
    final Collection<Node> endNodes;

    public MonoDirectionalTraversalDescription() {
        this(NO_STATEMENT);
    }

    public MonoDirectionalTraversalDescription(Supplier<? extends Resource> statementProvider) {
        this(PathExpanders.allTypesAndDirections(), Uniqueness.NODE_GLOBAL, null, Evaluators.all(), InitialBranchState.NO_STATE, (BranchOrderingPolicy)BranchOrderingPolicies.PREORDER_DEPTH_FIRST, null, null, statementProvider);
    }

    private MonoDirectionalTraversalDescription(PathExpander expander, UniquenessFactory uniqueness, Object uniquenessParameter, PathEvaluator evaluator, InitialBranchState initialState, BranchOrderingPolicy branchOrdering, Comparator<? super Path> sorting, Collection<Node> endNodes, Supplier<? extends Resource> statementSupplier) {
        this.expander = expander;
        this.uniqueness = uniqueness;
        this.uniquenessParameter = uniquenessParameter;
        this.evaluator = evaluator;
        this.branchOrdering = branchOrdering;
        this.sorting = sorting;
        this.endNodes = endNodes;
        this.initialState = initialState;
        this.statementSupplier = statementSupplier;
    }

    public Traverser traverse(Node startNode) {
        return this.traverse(Collections.singletonList(startNode));
    }

    public Traverser traverse(Node ... startNodes) {
        return this.traverse(Arrays.asList(startNodes));
    }

    public Traverser traverse(Iterable<Node> iterableStartNodes) {
        return new DefaultTraverser((Factory<TraverserIterator>)((Factory)() -> {
            Resource statement = this.statementSupplier.get();
            MonoDirectionalTraverserIterator iterator = new MonoDirectionalTraverserIterator(statement, this.uniqueness.create(this.uniquenessParameter), this.expander, this.branchOrdering, this.evaluator, iterableStartNodes, this.initialState, this.uniqueness);
            return this.sorting != null ? new SortingTraverserIterator(statement, this.sorting, iterator) : iterator;
        }));
    }

    public TraversalDescription uniqueness(UniquenessFactory uniqueness) {
        return new MonoDirectionalTraversalDescription(this.expander, uniqueness, null, this.evaluator, this.initialState, this.branchOrdering, this.sorting, this.endNodes, this.statementSupplier);
    }

    public TraversalDescription uniqueness(UniquenessFactory uniqueness, Object parameter) {
        if (this.uniqueness == uniqueness && (this.uniquenessParameter == null ? parameter == null : this.uniquenessParameter.equals(parameter))) {
            return this;
        }
        return new MonoDirectionalTraversalDescription(this.expander, uniqueness, parameter, this.evaluator, this.initialState, this.branchOrdering, this.sorting, this.endNodes, this.statementSupplier);
    }

    public TraversalDescription evaluator(Evaluator evaluator) {
        return this.evaluator((PathEvaluator)new Evaluator.AsPathEvaluator(evaluator));
    }

    public TraversalDescription evaluator(PathEvaluator evaluator) {
        if (this.evaluator == evaluator) {
            return this;
        }
        MonoDirectionalTraversalDescription.nullCheck(evaluator, Evaluator.class, "RETURN_ALL");
        return new MonoDirectionalTraversalDescription(this.expander, this.uniqueness, this.uniquenessParameter, MonoDirectionalTraversalDescription.addEvaluator(this.evaluator, evaluator), this.initialState, this.branchOrdering, this.sorting, this.endNodes, this.statementSupplier);
    }

    protected static PathEvaluator addEvaluator(PathEvaluator existing, PathEvaluator toAdd) {
        if (existing instanceof MultiEvaluator) {
            return ((MultiEvaluator)existing).add(toAdd);
        }
        return existing == Evaluators.all() ? toAdd : new MultiEvaluator(existing, toAdd);
    }

    protected static <T> void nullCheck(T parameter, Class<T> parameterType, String defaultName) {
        if (parameter == null) {
            String typeName = parameterType.getSimpleName();
            throw new IllegalArgumentException(typeName + " may not be null, use " + typeName + "." + defaultName + " instead.");
        }
    }

    public TraversalDescription order(BranchOrderingPolicy order) {
        if (this.branchOrdering == order) {
            return this;
        }
        return new MonoDirectionalTraversalDescription(this.expander, this.uniqueness, this.uniquenessParameter, this.evaluator, this.initialState, order, this.sorting, this.endNodes, this.statementSupplier);
    }

    public TraversalDescription depthFirst() {
        return this.order((BranchOrderingPolicy)BranchOrderingPolicies.PREORDER_DEPTH_FIRST);
    }

    public TraversalDescription breadthFirst() {
        return this.order((BranchOrderingPolicy)BranchOrderingPolicies.PREORDER_BREADTH_FIRST);
    }

    public TraversalDescription relationships(RelationshipType type) {
        return this.relationships(type, Direction.BOTH);
    }

    public TraversalDescription relationships(RelationshipType type, Direction direction) {
        if (this.expander instanceof StandardExpander) {
            return this.expand((PathExpander<?>)((StandardExpander)this.expander).add(type, direction));
        }
        throw new IllegalStateException("The current expander cannot be added to");
    }

    public TraversalDescription expand(PathExpander<?> expander) {
        if (expander.equals((Object)this.expander)) {
            return this;
        }
        return new MonoDirectionalTraversalDescription(expander, this.uniqueness, this.uniquenessParameter, this.evaluator, this.initialState, this.branchOrdering, this.sorting, this.endNodes, this.statementSupplier);
    }

    public <STATE> TraversalDescription expand(PathExpander<STATE> expander, InitialBranchState<STATE> initialState) {
        return new MonoDirectionalTraversalDescription(expander, this.uniqueness, this.uniquenessParameter, this.evaluator, initialState, this.branchOrdering, this.sorting, this.endNodes, this.statementSupplier);
    }

    public TraversalDescription sort(Comparator<? super Path> sorting) {
        return new MonoDirectionalTraversalDescription(this.expander, this.uniqueness, this.uniquenessParameter, this.evaluator, this.initialState, this.branchOrdering, sorting, this.endNodes, this.statementSupplier);
    }

    public TraversalDescription reverse() {
        return new MonoDirectionalTraversalDescription(this.expander.reverse(), this.uniqueness, this.uniquenessParameter, this.evaluator, this.initialState.reverse(), this.branchOrdering, this.sorting, this.endNodes, this.statementSupplier);
    }
}

