/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.unsafe.impl.batchimport.cache.FixedNumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.IntArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArray;

class FixedIntArray
extends FixedNumberArray<IntArray>
implements IntArray {
    private final int defaultValue;

    FixedIntArray(NumberArray[] chunks, long chunkSize, int defaultValue) {
        super(chunks, chunkSize);
        this.defaultValue = defaultValue;
    }

    @Override
    public void swap(long fromIndex, long toIndex, int numberOfEntries) {
        for (int i = 0; i < numberOfEntries; ++i) {
            int intermediary = this.get(fromIndex + (long)i);
            this.set(fromIndex + (long)i, this.get(toIndex + (long)i));
            this.set(toIndex + (long)i, intermediary);
        }
    }

    @Override
    public int get(long index) {
        IntArray chunk = (IntArray)this.chunkOrNullAt(index);
        return chunk != null ? chunk.get(this.index(index)) : this.defaultValue;
    }

    @Override
    public void set(long index, int value) {
        ((IntArray)this.chunkAt(index)).set(this.index(index), value);
    }

    @Override
    public IntArray fixate() {
        return this;
    }
}

