/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.io.File;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactoryState;
import org.neo4j.graphdb.security.URLAccessRule;
import org.neo4j.kernel.impl.factory.CommunityFacadeFactory;
import org.neo4j.kernel.impl.factory.Edition;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;

public class GraphDatabaseFactory {
    private final GraphDatabaseFactoryState state;

    public GraphDatabaseFactory() {
        this(new GraphDatabaseFactoryState());
    }

    protected GraphDatabaseFactory(GraphDatabaseFactoryState state) {
        this.state = state;
    }

    protected GraphDatabaseFactoryState getCurrentState() {
        return this.state;
    }

    protected GraphDatabaseFactoryState getStateCopy() {
        return new GraphDatabaseFactoryState(this.getCurrentState());
    }

    public GraphDatabaseService newEmbeddedDatabase(File storeDir) {
        return this.newEmbeddedDatabaseBuilder(storeDir).newGraphDatabase();
    }

    public GraphDatabaseBuilder newEmbeddedDatabaseBuilder(File storeDir) {
        GraphDatabaseFactoryState state = this.getStateCopy();
        GraphDatabaseBuilder.DatabaseCreator creator = this.createDatabaseCreator(storeDir, state);
        GraphDatabaseBuilder builder = this.createGraphDatabaseBuilder(creator);
        this.configure(builder);
        return builder;
    }

    protected GraphDatabaseBuilder createGraphDatabaseBuilder(GraphDatabaseBuilder.DatabaseCreator creator) {
        return new GraphDatabaseBuilder(creator);
    }

    protected GraphDatabaseBuilder.DatabaseCreator createDatabaseCreator(File storeDir, GraphDatabaseFactoryState state) {
        return config -> {
            config.put("unsupported.dbms.ephemeral", "false");
            GraphDatabaseFacadeFactory.Dependencies dependencies = state.databaseDependencies();
            return this.newDatabase(storeDir, config, dependencies);
        };
    }

    protected void configure(GraphDatabaseBuilder builder) {
    }

    protected GraphDatabaseService newDatabase(File storeDir, Map<String, String> config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        return new CommunityFacadeFactory().newFacade(storeDir, config, dependencies);
    }

    public GraphDatabaseFactory addURLAccessRule(String protocol, URLAccessRule rule) {
        this.getCurrentState().addURLAccessRule(protocol, rule);
        return this;
    }

    public GraphDatabaseFactory setUserLogProvider(LogProvider userLogProvider) {
        this.getCurrentState().setUserLogProvider(userLogProvider);
        return this;
    }

    public GraphDatabaseFactory setMonitors(Monitors monitors) {
        this.getCurrentState().setMonitors(monitors);
        return this;
    }

    public String getEdition() {
        return Edition.community.toString();
    }
}

