/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.function.Supplier;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.IndexReaderFactory;
import org.neo4j.kernel.impl.api.store.StoreIteratorNodeCursor;
import org.neo4j.kernel.impl.api.store.StoreIteratorRelationshipCursor;
import org.neo4j.kernel.impl.api.store.StoreSingleNodeCursor;
import org.neo4j.kernel.impl.api.store.StoreSingleRelationshipCursor;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.util.InstanceCache;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.LabelScanReader;

public class StoreStatement
implements StorageStatement {
    private final InstanceCache<StoreSingleNodeCursor> singleNodeCursor;
    private final InstanceCache<StoreIteratorNodeCursor> iteratorNodeCursor;
    private final InstanceCache<StoreSingleRelationshipCursor> singleRelationshipCursor;
    private final InstanceCache<StoreIteratorRelationshipCursor> iteratorRelationshipCursor;
    private final NeoStores neoStores;
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final Supplier<IndexReaderFactory> indexReaderFactorySupplier;
    private IndexReaderFactory indexReaderFactory;
    private final Supplier<LabelScanReader> labelScanStore;
    private LabelScanReader labelScanReader;
    private boolean closed;

    public StoreStatement(final NeoStores neoStores, final LockService lockService, Supplier<IndexReaderFactory> indexReaderFactory, Supplier<LabelScanReader> labelScanReaderSupplier) {
        this.neoStores = neoStores;
        this.indexReaderFactorySupplier = indexReaderFactory;
        this.labelScanStore = labelScanReaderSupplier;
        this.nodeStore = neoStores.getNodeStore();
        this.relationshipStore = neoStores.getRelationshipStore();
        this.singleNodeCursor = new InstanceCache<StoreSingleNodeCursor>(){

            @Override
            protected StoreSingleNodeCursor create() {
                return new StoreSingleNodeCursor(new NodeRecord(-1L), neoStores, StoreStatement.this, this, lockService);
            }
        };
        this.iteratorNodeCursor = new InstanceCache<StoreIteratorNodeCursor>(){

            @Override
            protected StoreIteratorNodeCursor create() {
                return new StoreIteratorNodeCursor(new NodeRecord(-1L), neoStores, StoreStatement.this, this, lockService);
            }
        };
        this.singleRelationshipCursor = new InstanceCache<StoreSingleRelationshipCursor>(){

            @Override
            protected StoreSingleRelationshipCursor create() {
                return new StoreSingleRelationshipCursor(new RelationshipRecord(-1L), neoStores, StoreStatement.this, this, lockService);
            }
        };
        this.iteratorRelationshipCursor = new InstanceCache<StoreIteratorRelationshipCursor>(){

            @Override
            protected StoreIteratorRelationshipCursor create() {
                return new StoreIteratorRelationshipCursor(new RelationshipRecord(-1L), neoStores, StoreStatement.this, this, lockService);
            }
        };
    }

    @Override
    public void acquire() {
        this.closed = false;
    }

    @Override
    public Cursor<NodeItem> acquireSingleNodeCursor(long nodeId) {
        this.neoStores.assertOpen();
        return this.singleNodeCursor.get().init(nodeId);
    }

    @Override
    public Cursor<NodeItem> acquireIteratorNodeCursor(PrimitiveLongIterator nodeIdIterator) {
        this.neoStores.assertOpen();
        return this.iteratorNodeCursor.get().init(nodeIdIterator);
    }

    @Override
    public Cursor<RelationshipItem> acquireSingleRelationshipCursor(long relId) {
        this.neoStores.assertOpen();
        return this.singleRelationshipCursor.get().init(relId);
    }

    @Override
    public Cursor<RelationshipItem> acquireIteratorRelationshipCursor(PrimitiveLongIterator iterator) {
        this.neoStores.assertOpen();
        return this.iteratorRelationshipCursor.get().init(iterator);
    }

    @Override
    public Cursor<NodeItem> nodesGetAllCursor() {
        return this.acquireIteratorNodeCursor((PrimitiveLongIterator)new AllStoreIdIterator(this.nodeStore));
    }

    @Override
    public Cursor<RelationshipItem> relationshipsGetAllCursor() {
        return this.acquireIteratorRelationshipCursor((PrimitiveLongIterator)new AllStoreIdIterator(this.relationshipStore));
    }

    @Override
    public void close() {
        assert (!this.closed);
        if (this.indexReaderFactory != null) {
            this.indexReaderFactory.close();
        }
        if (this.labelScanReader != null) {
            this.labelScanReader.close();
            this.labelScanReader = null;
        }
        this.closed = true;
    }

    @Override
    public LabelScanReader getLabelScanReader() {
        return this.labelScanReader != null ? this.labelScanReader : (this.labelScanReader = this.labelScanStore.get());
    }

    private IndexReaderFactory indexReaderFactory() {
        return this.indexReaderFactory != null ? this.indexReaderFactory : (this.indexReaderFactory = this.indexReaderFactorySupplier.get());
    }

    @Override
    public IndexReader getIndexReader(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexReaderFactory().newReader(descriptor);
    }

    @Override
    public IndexReader getFreshIndexReader(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexReaderFactory().newUnCachedReader(descriptor);
    }

    private class AllStoreIdIterator
    extends PrimitiveLongCollections.PrimitiveLongBaseIterator {
        private final CommonAbstractStore store;
        private long highId;
        private long currentId;

        public AllStoreIdIterator(CommonAbstractStore store) {
            this.store = store;
            this.highId = store.getHighestPossibleIdInUse();
        }

        protected boolean fetchNext() {
            while (true) {
                if (this.currentId <= this.highId) {
                    try {
                        boolean bl = this.next(this.currentId);
                        return bl;
                    }
                    finally {
                        ++this.currentId;
                    }
                }
                long newHighId = this.store.getHighestPossibleIdInUse();
                if (newHighId <= this.highId) break;
                this.highId = newHighId;
            }
            return false;
        }
    }
}

