/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.dbstructure;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.neo4j.helpers.collection.Visitable;
import org.neo4j.kernel.impl.util.dbstructure.ArgumentFormatter;

public class InvocationTracer<C>
implements InvocationHandler,
AutoCloseable {
    private final String generatorInfo;
    private final String generatedClassPackage;
    private final String generatedClassName;
    private final Class<C> interfaceClass;
    private final ArgumentFormatter argumentFormatter;
    private final Appendable output;
    private boolean open = true;

    public InvocationTracer(String generatorInfo, String generatedClassPackage, String generatedClassName, Class<C> interfaceClass, ArgumentFormatter argumentFormatter) throws IOException {
        this(generatorInfo, generatedClassPackage, generatedClassName, interfaceClass, argumentFormatter, new StringBuilder());
    }

    public InvocationTracer(String generatorInfo, String generatedClassPackage, String generatedClassName, Class<C> interfaceClass, ArgumentFormatter argumentFormatter, Appendable output) throws IOException {
        this.generatorInfo = generatorInfo;
        if (generatedClassName.contains(".") || generatedClassName.contains("%")) {
            throw new IllegalArgumentException("Invalid class name: " + generatedClassName);
        }
        if (generatedClassPackage.contains("%")) {
            throw new IllegalArgumentException("Invalid class package: " + generatedClassPackage);
        }
        this.generatedClassPackage = generatedClassPackage;
        this.generatedClassName = generatedClassName;
        this.interfaceClass = interfaceClass;
        this.argumentFormatter = argumentFormatter;
        this.output = output;
        this.formatPreamble(output);
    }

    public C newProxy() {
        return this.newProxy(this.interfaceClass);
    }

    public <P extends C> P newProxy(Class<P> proxyClass) {
        ClassLoader classLoader = proxyClass.getClassLoader();
        return proxyClass.cast(Proxy.newProxyInstance(classLoader, new Class[]{proxyClass}, (InvocationHandler)this));
    }

    @Override
    public void close() throws IOException {
        if (!this.open) {
            throw new IllegalStateException("Already closed");
        }
        InvocationTracer.formatAppendix(this.output);
        this.open = false;
    }

    private void formatPreamble(Appendable builder) throws IOException {
        String interfaceClassName;
        String interfaceSimpleName = this.interfaceClass.getSimpleName();
        String string = interfaceClassName = interfaceSimpleName.length() == 0 ? this.interfaceClass.getCanonicalName() : interfaceSimpleName;
        if (this.generatedClassPackage.length() > 0) {
            InvocationTracer.formatln(builder, "package %s;", this.generatedClassPackage);
            InvocationTracer.formatln(builder);
        }
        InvocationTracer.formatln(builder, "import %s;", Visitable.class.getCanonicalName());
        InvocationTracer.formatln(builder, "import %s;", this.interfaceClass.getCanonicalName());
        InvocationTracer.formatln(builder);
        for (String importExpr : this.argumentFormatter.imports()) {
            InvocationTracer.formatln(builder, "import %s;", importExpr);
        }
        InvocationTracer.formatln(builder);
        InvocationTracer.formatln(builder, "//", new Object[0]);
        InvocationTracer.formatln(builder, "// GENERATED FILE. DO NOT EDIT. ", new Object[0]);
        InvocationTracer.formatln(builder, "//", new Object[0]);
        InvocationTracer.formatln(builder, "// This has been generated by:", new Object[0]);
        InvocationTracer.formatln(builder, "//", new Object[0]);
        if (this.generatorInfo.length() > 0) {
            InvocationTracer.formatln(builder, "//   %s", this.generatorInfo);
            InvocationTracer.formatln(builder, "//", new Object[0]);
            InvocationTracer.formatln(builder, "// (using %s)", this.getClass().getCanonicalName());
            InvocationTracer.formatln(builder, "//", new Object[0]);
        } else {
            InvocationTracer.formatln(builder, "//   %s", this.getClass().getCanonicalName());
            InvocationTracer.formatln(builder, "//", new Object[0]);
        }
        InvocationTracer.formatln(builder);
        InvocationTracer.formatln(builder, "public enum %s", this.generatedClassName);
        InvocationTracer.formatln(builder, "implements %s<%s>", Visitable.class.getSimpleName(), interfaceClassName);
        InvocationTracer.formatln(builder, "{", new Object[0]);
        InvocationTracer.formatln(builder, "    INSTANCE;", new Object[0]);
        InvocationTracer.formatln(builder);
        InvocationTracer.formatln(builder, "    public void accept( %s visitor )", interfaceClassName);
        InvocationTracer.formatln(builder, "    {", new Object[0]);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.open) {
            if (method.getReturnType().equals(Void.TYPE)) {
                InvocationTracer.format(this.output, "        visitor.%s(", method.getName());
                for (int i = 0; i < args.length; ++i) {
                    Object arg = args[i];
                    if (i > 0) {
                        InvocationTracer.format(this.output, ", ", new Object[0]);
                    } else {
                        InvocationTracer.format(this.output, " ", new Object[0]);
                    }
                    this.argumentFormatter.formatArgument(this.output, arg);
                }
                if (args.length == 0) {
                    InvocationTracer.formatln(this.output, ");", new Object[0]);
                } else {
                    InvocationTracer.formatln(this.output, " );", new Object[0]);
                }
                return null;
            }
            throw new IllegalArgumentException("InvocationTraceGenerator only works with void methods");
        }
        throw new IllegalStateException("Tracer already closed");
    }

    private static void formatAppendix(Appendable builder) throws IOException {
        InvocationTracer.formatln(builder, "   }", new Object[0]);
        InvocationTracer.formatln(builder, "}", new Object[0]);
        InvocationTracer.formatln(builder);
        InvocationTracer.formatln(builder, "/* END OF GENERATED CONTENT */", new Object[0]);
    }

    private static void formatln(Appendable output, String format, Object ... args) throws IOException {
        InvocationTracer.format(output, format, args);
        InvocationTracer.formatln(output);
    }

    private static void format(Appendable output, String format, Object ... args) throws IOException {
        output.append(String.format(format, args));
    }

    private static void formatln(Appendable output) throws IOException {
        output.append(System.lineSeparator());
    }
}

