/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.function.LongPredicate;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.PropertyValueComparison;
import org.neo4j.kernel.impl.api.operations.EntityOperations;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.NodeItem;

public class LookupFilter {
    public static PrimitiveLongIterator exactIndexMatches(PropertyAccessor accessor, PrimitiveLongIterator indexedNodeIds, int propertyKeyId, Object value) {
        if (LookupFilter.isNumberOrArray(value)) {
            return PrimitiveLongCollections.filter((PrimitiveLongIterator)indexedNodeIds, (LongPredicate)new LookupBasedExactMatchPredicate(accessor, propertyKeyId, value));
        }
        return indexedNodeIds;
    }

    public static PrimitiveLongIterator exactIndexMatches(EntityOperations operations, KernelStatement state, PrimitiveLongIterator indexedNodeIds, int propertyKeyId, Object value) {
        if (LookupFilter.isNumberOrArray(value)) {
            return PrimitiveLongCollections.filter((PrimitiveLongIterator)indexedNodeIds, (LongPredicate)new OperationsBasedExactMatchPredicate(operations, state, propertyKeyId, value));
        }
        return indexedNodeIds;
    }

    public static PrimitiveLongIterator exactRangeMatches(EntityOperations operations, KernelStatement state, PrimitiveLongIterator indexedNodeIds, int propertyKeyId, Number lower, boolean includeLower, Number upper, boolean includeUpper) {
        return PrimitiveLongCollections.filter((PrimitiveLongIterator)indexedNodeIds, (LongPredicate)new NumericRangeMatchPredicate(operations, state, propertyKeyId, lower, includeLower, upper, includeUpper));
    }

    private static boolean isNumberOrArray(Object value) {
        return value instanceof Number || value.getClass().isArray();
    }

    static class NumericRangeMatchPredicate
    implements LongPredicate {
        final EntityOperations readOperations;
        final KernelStatement state;
        final int propertyKeyId;
        final Number lower;
        final boolean includeLower;
        final Number upper;
        final boolean includeUpper;

        NumericRangeMatchPredicate(EntityOperations readOperations, KernelStatement state, int propertyKeyId, Number lower, boolean includeLower, Number upper, boolean includeUpper) {
            this.readOperations = readOperations;
            this.state = state;
            this.propertyKeyId = propertyKeyId;
            this.lower = lower;
            this.includeLower = includeLower;
            this.upper = upper;
            this.includeUpper = includeUpper;
        }

        @Override
        public boolean test(long nodeId) {
            try (Cursor<NodeItem> node = this.readOperations.nodeCursor(this.state, nodeId);){
                boolean bl = node.next() && this.inRange(((NodeItem)node.get()).getProperty(this.propertyKeyId));
                return bl;
            }
        }

        boolean inRange(Object value) {
            int compare;
            if (value == null) {
                return false;
            }
            if (!(value instanceof Number)) {
                throw new IllegalStateException("Unable to verify range for non-numeric property value: " + value + " for property key: " + this.propertyKeyId);
            }
            Number number = (Number)value;
            if (this.lower != null && ((compare = PropertyValueComparison.COMPARE_NUMBERS.compare(number, this.lower)) < 0 || !this.includeLower && compare == 0)) {
                return false;
            }
            return this.upper == null || (compare = PropertyValueComparison.COMPARE_NUMBERS.compare(number, this.upper)) <= 0 && (this.includeUpper || compare != 0);
        }
    }

    private static class LookupBasedExactMatchPredicate
    extends BaseExactMatchPredicate {
        final PropertyAccessor accessor;

        LookupBasedExactMatchPredicate(PropertyAccessor accessor, int propertyKeyId, Object value) {
            super(propertyKeyId, value);
            this.accessor = accessor;
        }

        @Override
        Property nodeProperty(long nodeId, int propertyKeyId) throws EntityNotFoundException {
            return this.accessor.getProperty(nodeId, propertyKeyId);
        }
    }

    private static class OperationsBasedExactMatchPredicate
    extends BaseExactMatchPredicate {
        final EntityReadOperations readOperations;
        final KernelStatement state;

        OperationsBasedExactMatchPredicate(EntityReadOperations readOperations, KernelStatement state, int propertyKeyId, Object value) {
            super(propertyKeyId, value);
            this.readOperations = readOperations;
            this.state = state;
        }

        @Override
        Property nodeProperty(long nodeId, int propertyKeyId) throws EntityNotFoundException {
            Throwable throwable = null;
            try (Cursor<NodeItem> node = this.readOperations.nodeCursor(this.state, nodeId);){
                if (node.next()) {
                    Object value = ((NodeItem)node.get()).getProperty(propertyKeyId);
                    Property property = value == null ? Property.noNodeProperty(nodeId, propertyKeyId) : Property.property(propertyKeyId, value);
                    return property;
                }
                try {
                    throw new EntityNotFoundException(EntityType.NODE, nodeId);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    private static abstract class BaseExactMatchPredicate
    implements LongPredicate {
        private final int propertyKeyId;
        private final Object value;

        BaseExactMatchPredicate(int propertyKeyId, Object value) {
            this.propertyKeyId = propertyKeyId;
            this.value = value;
        }

        @Override
        public boolean test(long nodeId) {
            try {
                return this.nodeProperty(nodeId, this.propertyKeyId).valueEquals(this.value);
            }
            catch (EntityNotFoundException ignored) {
                return false;
            }
        }

        abstract Property nodeProperty(long var1, int var3) throws EntityNotFoundException;
    }
}

