/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.function.Consumer;
import org.neo4j.kernel.impl.api.store.StoreAbstractNodeCursor;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;

public class StoreSingleNodeCursor
extends StoreAbstractNodeCursor {
    private long nodeId;
    private final Consumer<StoreSingleNodeCursor> instanceCache;

    public StoreSingleNodeCursor(NodeRecord nodeRecord, NeoStores neoStores, StoreStatement storeStatement, Consumer<StoreSingleNodeCursor> instanceCache, RecordCursors cursors) {
        super(nodeRecord, neoStores, storeStatement, cursors);
        this.instanceCache = instanceCache;
    }

    public StoreSingleNodeCursor init(long nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public boolean next() {
        if (this.nodeId != -1L) {
            try {
                boolean bl = this.cursors.node().next(this.nodeId, this.nodeRecord, RecordLoad.CHECK);
                return bl;
            }
            finally {
                this.nodeId = -1L;
            }
        }
        return false;
    }

    public void close() {
        this.instanceCache.accept(this);
    }
}

