/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.standard;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.format.standard.TokenRecordFormat;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;

public class PropertyKeyTokenRecordFormat
extends TokenRecordFormat<PropertyKeyTokenRecord> {
    public PropertyKeyTokenRecordFormat() {
        super(9, 32);
    }

    @Override
    public PropertyKeyTokenRecord newRecord() {
        return new PropertyKeyTokenRecord(-1);
    }

    @Override
    protected void readRecordData(PageCursor cursor, PropertyKeyTokenRecord record, boolean inUse) {
        int propertyCount = cursor.getInt();
        int nameId = cursor.getInt();
        record.initialize(inUse, nameId, propertyCount);
    }

    @Override
    protected void writeRecordData(PropertyKeyTokenRecord record, PageCursor cursor) {
        cursor.putInt(record.getPropertyCount());
        cursor.putInt(record.getNameId());
    }
}

