/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import org.neo4j.helpers.collection.LruCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;

public class TransactionMetadataCache {
    private final LruCache<Long, TransactionMetadata> txStartPositionCache;

    public TransactionMetadataCache(int transactionCacheSize) {
        this.txStartPositionCache = new LruCache("Tx start position cache", transactionCacheSize);
    }

    public void clear() {
        this.txStartPositionCache.clear();
    }

    public TransactionMetadata getTransactionMetadata(long txId) {
        return (TransactionMetadata)this.txStartPositionCache.get((Object)txId);
    }

    public TransactionMetadata cacheTransactionMetadata(long txId, LogPosition position, int masterId, int authorId, long checksum) {
        if (position.getByteOffset() == -1L) {
            throw new RuntimeException("StartEntry.position is " + position);
        }
        TransactionMetadata result = new TransactionMetadata(masterId, authorId, position, checksum);
        this.txStartPositionCache.put((Object)txId, (Object)result);
        return result;
    }

    public static class TransactionMetadata {
        private final int masterId;
        private final int authorId;
        private final LogPosition startPosition;
        private final long checksum;

        public TransactionMetadata(int masterId, int authorId, LogPosition startPosition, long checksum) {
            this.masterId = masterId;
            this.authorId = authorId;
            this.startPosition = startPosition;
            this.checksum = checksum;
        }

        public int getMasterId() {
            return this.masterId;
        }

        public int getAuthorId() {
            return this.authorId;
        }

        public LogPosition getStartPosition() {
            return this.startPosition;
        }

        public long getChecksum() {
            return this.checksum;
        }

        public String toString() {
            return "TransactionMetadata[masterId=" + this.masterId + ", authorId=" + this.authorId + ", startPosition=" + this.startPosition + ", checksum=" + this.checksum + ']';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransactionMetadata that = (TransactionMetadata)o;
            if (this.authorId != that.authorId) {
                return false;
            }
            if (this.checksum != that.checksum) {
                return false;
            }
            if (this.masterId != that.masterId) {
                return false;
            }
            return this.startPosition.equals(that.startPosition);
        }

        public int hashCode() {
            int result = this.masterId;
            result = 31 * result + this.authorId;
            result = 31 * result + this.startPosition.hashCode();
            result = 31 * result + (int)(this.checksum ^ this.checksum >>> 32);
            return result;
        }
    }
}

