/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.util.Collection;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;

public class InputRelationship
extends InputEntity {
    private final Object startNode;
    private final Object endNode;
    private String type;
    private Integer typeId;
    private final Group startNodeGroup;
    private final Group endNodeGroup;

    public InputRelationship(String sourceDescription, long lineNumber, long position, Object[] properties, Long firstPropertyId, Object startNode, Object endNode, String type, Integer typeId) {
        this(sourceDescription, lineNumber, position, properties, firstPropertyId, Group.GLOBAL, startNode, Group.GLOBAL, endNode, type, typeId);
    }

    public InputRelationship(String sourceDescription, long lineNumber, long position, Object[] properties, Long firstPropertyId, Group startNodeGroups, Object startNode, Group endNodeGroups, Object endNode, String type, Integer typeId) {
        super(sourceDescription, lineNumber, position, properties, firstPropertyId);
        this.startNodeGroup = startNodeGroups;
        this.startNode = startNode;
        this.endNodeGroup = endNodeGroups;
        this.endNode = endNode;
        this.type = type;
        this.typeId = typeId;
    }

    public Group startNodeGroup() {
        return this.startNodeGroup;
    }

    public Object startNode() {
        return this.startNode;
    }

    public Group endNodeGroup() {
        return this.endNodeGroup;
    }

    public Object endNode() {
        return this.endNode;
    }

    public String type() {
        return this.type;
    }

    public boolean hasTypeId() {
        return this.typeId != null;
    }

    public int typeId() {
        return this.typeId;
    }

    public void setType(String type) {
        this.type = type;
        this.typeId = null;
    }

    @Override
    protected void toStringFields(Collection<Pair<String, ?>> fields) {
        super.toStringFields(fields);
        fields.add(Pair.of((Object)"startNode", (Object)this.startNode));
        fields.add(Pair.of((Object)"endNode", (Object)this.endNode));
        if (this.hasTypeId()) {
            fields.add(Pair.of((Object)"typeId", (Object)this.typeId));
        } else {
            fields.add(Pair.of((Object)"type", (Object)this.type));
        }
    }

    public Object typeAsObject() {
        return this.hasTypeId() ? Integer.valueOf(this.typeId()) : this.type();
    }
}

