/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class CalculateRelationshipsStep
extends ProcessorStep<Batch<InputRelationship, RelationshipRecord>> {
    private final RelationshipStore relationshipStore;
    private long numberOfRelationships;

    public CalculateRelationshipsStep(StageControl control, Configuration config, RelationshipStore relationshipStore) {
        super(control, "RelationshipCalculator", config, 1, new StatsProvider[0]);
        this.relationshipStore = relationshipStore;
    }

    @Override
    protected void process(Batch<InputRelationship, RelationshipRecord> batch, BatchSender sender) throws Throwable {
        this.numberOfRelationships += (long)((InputRelationship[])batch.input).length;
        sender.send(batch);
    }

    @Override
    protected void done() {
        long highestId = this.relationshipStore.getHighId() + this.numberOfRelationships;
        this.relationshipStore.setHighestPossibleIdInUse(highestId);
        super.done();
    }
}

