/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.AbstractStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public abstract class ProducerStep
extends AbstractStep<Void> {
    protected final int batchSize;

    public ProducerStep(StageControl control, String name, Configuration config) {
        super(control, name, config, new StatsProvider[0]);
        this.batchSize = config.batchSize();
    }

    @Override
    public long receive(long ticket, Void batch) {
        new Thread(this.name()){

            @Override
            public void run() {
                ProducerStep.this.assertHealthy();
                try {
                    ProducerStep.this.process();
                    ProducerStep.this.endOfUpstream();
                }
                catch (Throwable e) {
                    ProducerStep.this.issuePanic(e, false);
                }
            }
        }.start();
        return 0L;
    }

    protected void process() {
        Object batch = null;
        while (true) {
            long startTime = System.nanoTime();
            batch = this.nextBatchOrNull(this.doneBatches.get(), this.batchSize);
            if (batch == null) break;
            this.totalProcessingTime.add(System.nanoTime() - startTime);
            this.downstreamIdleTime.addAndGet(this.downstream.receive(this.doneBatches.getAndIncrement(), batch));
            this.assertHealthy();
        }
    }

    protected abstract Object nextBatchOrNull(long var1, int var3);
}

