/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import java.util.Optional;
import org.neo4j.kernel.impl.api.BatchTransactionApplier;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.CountsStoreTransactionApplier;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class CountsStoreBatchTransactionApplier
extends BatchTransactionApplier.Adapter {
    private final CountsTracker countsTracker;
    private CountsAccessor.Updater countsUpdater;
    private final TransactionApplicationMode mode;

    public CountsStoreBatchTransactionApplier(CountsTracker countsTracker, TransactionApplicationMode mode) {
        this.countsTracker = countsTracker;
        this.mode = mode;
    }

    @Override
    public TransactionApplier startTx(CommandsToApply transaction) throws IOException {
        Optional<CountsAccessor.Updater> result = this.countsTracker.apply(transaction.transactionId());
        if (result.isPresent()) {
            this.countsUpdater = result.get();
        }
        assert (this.countsUpdater != null || this.mode == TransactionApplicationMode.RECOVERY);
        return new CountsStoreTransactionApplier(this.mode, this.countsUpdater);
    }
}

