/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.nio.ByteBuffer;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.DynamicNumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.HeapByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class DynamicByteArray
extends DynamicNumberArray<ByteArray>
implements ByteArray {
    private final byte[] defaultValue;
    private final ByteBuffer defaultValueConvenienceBuffer;

    public DynamicByteArray(NumberArrayFactory factory, long chunkSize, byte[] defaultValue) {
        super(factory, chunkSize, (NumberArray[])new ByteArray[0]);
        this.defaultValue = defaultValue;
        this.defaultValueConvenienceBuffer = ByteBuffer.wrap(defaultValue);
    }

    @Override
    public void swap(long fromIndex, long toIndex, int numberOfEntries) {
        byte[] intermediary = (byte[])this.defaultValue.clone();
        byte[] transport = (byte[])this.defaultValue.clone();
        for (int i = 0; i < numberOfEntries; ++i) {
            this.get(fromIndex + (long)i, intermediary);
            this.get(toIndex + (long)i, transport);
            this.set(fromIndex + (long)i, transport);
            this.set(toIndex + (long)i, intermediary);
        }
    }

    @Override
    public void get(long index, byte[] into) {
        ByteArray chunk = (ByteArray)this.chunkOrNullAt(index);
        if (chunk != null) {
            chunk.get(index, into);
        } else {
            System.arraycopy(this.defaultValue, 0, into, 0, this.defaultValue.length);
        }
    }

    @Override
    public byte getByte(long index, int offset) {
        ByteArray chunk = (ByteArray)this.chunkOrNullAt(index);
        return chunk != null ? chunk.getByte(index, offset) : this.defaultValueConvenienceBuffer.get(offset);
    }

    @Override
    public short getShort(long index, int offset) {
        ByteArray chunk = (ByteArray)this.chunkOrNullAt(index);
        return chunk != null ? chunk.getShort(index, offset) : this.defaultValueConvenienceBuffer.getShort(offset);
    }

    @Override
    public int getInt(long index, int offset) {
        ByteArray chunk = (ByteArray)this.chunkOrNullAt(index);
        return chunk != null ? chunk.getInt(index, offset) : this.defaultValueConvenienceBuffer.getInt(offset);
    }

    @Override
    public int get3ByteInt(long index, int offset) {
        ByteArray chunk = (ByteArray)this.chunkOrNullAt(index);
        return chunk != null ? chunk.get3ByteInt(index, offset) : HeapByteArray.get3ByteIntFromByteBuffer(this.defaultValueConvenienceBuffer, offset);
    }

    @Override
    public long get6ByteLong(long index, int offset) {
        ByteArray chunk = (ByteArray)this.chunkOrNullAt(index);
        return chunk != null ? chunk.get6ByteLong(index, offset) : HeapByteArray.get6BLongFromByteBuffer(this.defaultValueConvenienceBuffer, offset);
    }

    @Override
    public long getLong(long index, int offset) {
        ByteArray chunk = (ByteArray)this.chunkOrNullAt(index);
        return chunk != null ? chunk.getLong(index, offset) : this.defaultValueConvenienceBuffer.getLong(offset);
    }

    @Override
    public void set(long index, byte[] value) {
        ((ByteArray)this.at(index)).set(index, value);
    }

    @Override
    public void setByte(long index, int offset, byte value) {
        ((ByteArray)this.at(index)).setByte(index, offset, value);
    }

    @Override
    public void setShort(long index, int offset, short value) {
        ((ByteArray)this.at(index)).setShort(index, offset, value);
    }

    @Override
    public void setInt(long index, int offset, int value) {
        ((ByteArray)this.at(index)).setInt(index, offset, value);
    }

    @Override
    public void set6ByteLong(long index, int offset, long value) {
        ((ByteArray)this.at(index)).set6ByteLong(index, offset, value);
    }

    @Override
    public void setLong(long index, int offset, long value) {
        ((ByteArray)this.at(index)).setLong(index, offset, value);
    }

    @Override
    public void set3ByteInt(long index, int offset, int value) {
        ((ByteArray)this.at(index)).set3ByteInt(index, offset, value);
    }

    @Override
    protected ByteArray addChunk(long chunkSize, long base) {
        return this.factory.newByteArray(chunkSize, this.defaultValue, base);
    }
}

