/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.cursor;

import java.util.Arrays;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.cursor.EntityItemHelper;
import org.neo4j.kernel.impl.api.store.CursorRelationshipIterator;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.util.Cursors;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.LabelItem;
import org.neo4j.storageengine.api.NodeItem;

public abstract class NodeItemHelper
extends EntityItemHelper
implements NodeItem {
    @Override
    public boolean hasLabel(int labelId) {
        try (Cursor<LabelItem> labelCursor = this.label(labelId);){
            boolean bl = labelCursor.next();
            return bl;
        }
    }

    @Override
    public PrimitiveIntIterator getLabels() {
        return Cursors.intIterator(this.labels(), GET_LABEL);
    }

    @Override
    public RelationshipIterator getRelationships(Direction direction, int[] relTypes) {
        relTypes = NodeItemHelper.deduplicate(relTypes);
        return new CursorRelationshipIterator(this.relationships(direction, relTypes));
    }

    @Override
    public RelationshipIterator getRelationships(Direction direction) {
        return new CursorRelationshipIterator(this.relationships(direction));
    }

    @Override
    public PrimitiveIntIterator getRelationshipTypes() {
        return Cursors.intIterator(this.relationshipTypes(), GET_RELATIONSHIP_TYPE);
    }

    private static int[] deduplicate(int[] types) {
        int unique = 0;
        for (int i = 0; i < types.length; ++i) {
            int type = types[i];
            for (int j = 0; j < unique; ++j) {
                if (type != types[j]) continue;
                type = -1;
                break;
            }
            if (type == -1) continue;
            types[unique++] = types[i];
        }
        if (unique < types.length) {
            types = Arrays.copyOf(types, unique);
        }
        return types;
    }
}

