/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.security;

import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.security.AuthSubject;
import org.neo4j.kernel.api.security.SecurityContext;

public class AnonymousContext
implements SecurityContext {
    private final AccessMode accessMode;

    private AnonymousContext(AccessMode accessMode) {
        this.accessMode = accessMode;
    }

    public static AnonymousContext none() {
        return new AnonymousContext(AccessMode.Static.NONE);
    }

    public static AnonymousContext read() {
        return new AnonymousContext(AccessMode.Static.READ);
    }

    public static AnonymousContext write() {
        return new AnonymousContext(AccessMode.Static.WRITE);
    }

    public static AnonymousContext writeOnly() {
        return new AnonymousContext(AccessMode.Static.WRITE_ONLY);
    }

    @Override
    public AuthSubject subject() {
        return AuthSubject.ANONYMOUS;
    }

    @Override
    public boolean isAdmin() {
        return false;
    }

    @Override
    public SecurityContext freeze() {
        return this;
    }

    @Override
    public SecurityContext withMode(AccessMode mode) {
        return new SecurityContext.Frozen(this.subject(), mode);
    }

    @Override
    public AccessMode mode() {
        return this.accessMode;
    }

    public String toString() {
        return this.defaultString("anonymous");
    }
}

