/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import org.neo4j.kernel.impl.transaction.log.checkpoint.AbstractCheckPointThreshold;

public class CountCommittedTransactionThreshold
extends AbstractCheckPointThreshold {
    private final int notificationThreshold;
    private volatile long nextTransactionIdTarget;

    public CountCommittedTransactionThreshold(int notificationThreshold) {
        this.notificationThreshold = notificationThreshold;
    }

    @Override
    public void initialize(long transactionId) {
        this.nextTransactionIdTarget = transactionId + (long)this.notificationThreshold;
    }

    @Override
    protected boolean thresholdReached(long lastCommittedTransactionId) {
        return lastCommittedTransactionId >= this.nextTransactionIdTarget;
    }

    @Override
    protected String description() {
        return "tx count threshold";
    }

    @Override
    public void checkPointHappened(long transactionId) {
        this.nextTransactionIdTarget = transactionId + (long)this.notificationThreshold;
    }
}

