/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.ToIntFunction;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.cursor.IOCursor;
import org.neo4j.graphdb.Resource;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;

public class Cursors {
    private static Cursor<Object> EMPTY = new Cursor<Object>(){

        public boolean next() {
            return false;
        }

        public Object get() {
            return null;
        }

        public void close() {
        }
    };

    public static <T> Cursor<T> empty() {
        return EMPTY;
    }

    public static <T> Cursor<T> cursor(final T ... items) {
        return new Cursor<T>(){
            int idx = 0;
            T current;

            public boolean next() {
                if (this.idx < items.length) {
                    this.current = items[this.idx++];
                    return true;
                }
                return false;
            }

            public void close() {
                this.idx = 0;
                this.current = null;
            }

            public T get() {
                if (this.current == null) {
                    throw new IllegalStateException();
                }
                return this.current;
            }
        };
    }

    public static <T> Cursor<T> cursor(final Iterable<T> items) {
        return new Cursor<T>(){
            Iterator<T> iterator;
            T current;
            {
                this.iterator = items.iterator();
            }

            public boolean next() {
                if (this.iterator.hasNext()) {
                    this.current = this.iterator.next();
                    return true;
                }
                return false;
            }

            public void close() {
                this.iterator = items.iterator();
                this.current = null;
            }

            public T get() {
                if (this.current == null) {
                    throw new IllegalStateException();
                }
                return this.current;
            }
        };
    }

    public static TransactionCursor txCursor(final Cursor<CommittedTransactionRepresentation> cursor) {
        return new TransactionCursor(){

            @Override
            public LogPosition position() {
                throw new UnsupportedOperationException("LogPosition does not apply when moving a generic cursor over a list of transactions");
            }

            public boolean next() throws IOException {
                return cursor.next();
            }

            public void close() throws IOException {
                cursor.close();
            }

            public CommittedTransactionRepresentation get() {
                return (CommittedTransactionRepresentation)cursor.get();
            }
        };
    }

    public static <T> IOCursor<T> io(final Cursor<T> cursor) {
        return new IOCursor<T>(){

            public boolean next() throws IOException {
                return cursor.next();
            }

            public void close() throws IOException {
                cursor.close();
            }

            public T get() {
                return cursor.get();
            }
        };
    }

    public static <T> PrimitiveIntIterator intIterator(Cursor<T> resourceCursor, ToIntFunction<T> map) {
        return new CursorPrimitiveIntIterator<T>(resourceCursor, map);
    }

    private static class CursorPrimitiveIntIterator<T>
    implements PrimitiveIntIterator,
    Resource {
        private final ToIntFunction<T> map;
        private Cursor<T> cursor;
        private boolean hasNext;

        public CursorPrimitiveIntIterator(Cursor<T> resourceCursor, ToIntFunction<T> map) {
            this.map = map;
            this.cursor = resourceCursor;
            this.hasNext = this.nextCursor();
        }

        private boolean nextCursor() {
            if (this.cursor != null) {
                boolean hasNext = this.cursor.next();
                if (!hasNext) {
                    this.close();
                }
                return hasNext;
            }
            return false;
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public int next() {
            if (this.hasNext) {
                try {
                    int n = this.map.applyAsInt(this.cursor.get());
                    return n;
                }
                finally {
                    this.hasNext = this.nextCursor();
                }
            }
            throw new NoSuchElementException();
        }

        public void close() {
            if (this.cursor != null) {
                this.cursor.close();
                this.cursor = null;
            }
        }
    }
}

