/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema_new;

import java.util.Arrays;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.schema_new.SchemaComputer;
import org.neo4j.kernel.api.schema_new.SchemaDescriptor;
import org.neo4j.kernel.api.schema_new.SchemaProcessor;
import org.neo4j.kernel.api.schema_new.SchemaUtil;

public class RelationTypeSchemaDescriptor
implements SchemaDescriptor {
    private final int relTypeId;
    private final int[] propertyIds;

    RelationTypeSchemaDescriptor(int relTypeId, int ... propertyIds) {
        this.relTypeId = relTypeId;
        this.propertyIds = propertyIds;
    }

    @Override
    public <R> R computeWith(SchemaComputer<R> processor) {
        return processor.computeSpecific(this);
    }

    @Override
    public void processWith(SchemaProcessor processor) {
        processor.processSpecific(this);
    }

    @Override
    public String userDescription(TokenNameLookup tokenNameLookup) {
        return String.format("-[:%s(%s)]-", tokenNameLookup.relationshipTypeGetName(this.relTypeId), SchemaUtil.niceProperties(tokenNameLookup, this.propertyIds));
    }

    public int getRelTypeId() {
        return this.relTypeId;
    }

    @Override
    public int[] getPropertyIds() {
        return this.propertyIds;
    }

    public int getPropertyId() {
        if (this.propertyIds.length != 1) {
            throw new IllegalStateException("Single property schema requires one property but had " + this.propertyIds.length);
        }
        return this.propertyIds[0];
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof RelationTypeSchemaDescriptor) {
            RelationTypeSchemaDescriptor that = (RelationTypeSchemaDescriptor)o;
            return this.relTypeId == that.getRelTypeId() && Arrays.equals(this.propertyIds, that.getPropertyIds());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.propertyIds) + 31 * this.relTypeId;
    }
}

