/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.neo4j.function.Predicates;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.schema_new.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.builtinprocs.IndexSpecifier;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingMode;

public class IndexProcedures
implements AutoCloseable {
    private final Statement statement;
    private final ReadOperations operations;
    private final IndexingService indexingService;

    public IndexProcedures(KernelTransaction tx, IndexingService indexingService) {
        this.statement = tx.acquireStatement();
        this.operations = this.statement.readOperations();
        this.indexingService = indexingService;
    }

    public void awaitIndex(String indexSpecification, long timeout, TimeUnit timeoutUnits) throws ProcedureException {
        IndexSpecifier index = this.parse(indexSpecification);
        int labelId = this.getLabelId(index.label());
        int[] propertyKeyIds = this.getPropertyIds(index.properties());
        this.waitUntilOnline(this.getIndex(labelId, propertyKeyIds, index), index, timeout, timeoutUnits);
    }

    public void resampleIndex(String indexSpecification) throws ProcedureException {
        IndexSpecifier index = this.parse(indexSpecification);
        int labelId = this.getLabelId(index.label());
        int[] propertyKeyIds = this.getPropertyIds(index.properties());
        try {
            this.triggerSampling(this.getIndex(labelId, propertyKeyIds, index));
        }
        catch (IndexNotFoundKernelException e) {
            throw new ProcedureException(e.status(), e.getMessage(), e);
        }
    }

    public void resampleOutdatedIndexes() {
        this.indexingService.triggerIndexSampling(IndexSamplingMode.TRIGGER_REBUILD_UPDATED);
    }

    private IndexSpecifier parse(String specification) {
        return new IndexSpecifier(specification);
    }

    private int getLabelId(String labelName) throws ProcedureException {
        int labelId = this.operations.labelGetForName(labelName);
        if (labelId == -1) {
            throw new ProcedureException((Status)Status.Schema.LabelAccessFailed, "No such label %s", labelName);
        }
        return labelId;
    }

    private int[] getPropertyIds(String[] propertyKeyNames) throws ProcedureException {
        int[] propertyKeyIds = new int[propertyKeyNames.length];
        for (int i = 0; i < propertyKeyIds.length; ++i) {
            int propertyKeyId = this.operations.propertyKeyGetForName(propertyKeyNames[i]);
            if (propertyKeyId == -1) {
                throw new ProcedureException((Status)Status.Schema.PropertyKeyAccessFailed, "No such property key %s", propertyKeyNames);
            }
            propertyKeyIds[i] = propertyKeyId;
        }
        return propertyKeyIds;
    }

    private NewIndexDescriptor getIndex(int labelId, int[] propertyKeyIds, IndexSpecifier index) throws ProcedureException {
        try {
            return this.operations.indexGetForSchema(SchemaDescriptorFactory.forLabel(labelId, propertyKeyIds));
        }
        catch (SchemaRuleNotFoundException e) {
            throw new ProcedureException((Status)Status.Schema.IndexNotFound, (Throwable)e, "No index on %s", index);
        }
    }

    private void waitUntilOnline(NewIndexDescriptor index, IndexSpecifier indexDescription, long timeout, TimeUnit timeoutUnits) throws ProcedureException {
        try {
            Predicates.awaitEx(() -> this.isOnline(indexDescription, index), (long)timeout, (TimeUnit)timeoutUnits);
        }
        catch (TimeoutException e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureTimedOut, "Index on %s did not come online within %s %s", new Object[]{indexDescription, timeout, timeoutUnits});
        }
    }

    private boolean isOnline(IndexSpecifier indexDescription, NewIndexDescriptor index) throws ProcedureException {
        InternalIndexState state = this.getState(indexDescription, index);
        switch (state) {
            case POPULATING: {
                return false;
            }
            case ONLINE: {
                return true;
            }
            case FAILED: {
                throw new ProcedureException((Status)Status.Schema.IndexCreationFailed, "Index on %s is in failed state", indexDescription);
            }
        }
        throw new IllegalStateException("Unknown index state " + (Object)((Object)state));
    }

    private InternalIndexState getState(IndexSpecifier indexDescription, NewIndexDescriptor index) throws ProcedureException {
        try {
            return this.operations.indexGetState(index);
        }
        catch (IndexNotFoundKernelException e) {
            throw new ProcedureException((Status)Status.Schema.IndexNotFound, (Throwable)e, "No index on %s", indexDescription);
        }
    }

    private void triggerSampling(NewIndexDescriptor index) throws IndexNotFoundKernelException {
        this.indexingService.triggerIndexSampling(index.schema(), IndexSamplingMode.TRIGGER_REBUILD_ALL);
    }

    @Override
    public void close() {
        this.statement.close();
    }
}

