/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.storageengine.api.StorageCommand;

public class PhysicalTransactionRepresentation
implements TransactionRepresentation {
    private final Collection<StorageCommand> commands;
    private byte[] additionalHeader;
    private int masterId;
    private int authorId;
    private long timeStarted;
    private long latestCommittedTxWhenStarted;
    private long timeCommitted;
    private int lockSessionIdentifier;

    public PhysicalTransactionRepresentation(Collection<StorageCommand> commands) {
        this.commands = commands;
    }

    public void setHeader(byte[] additionalHeader, int masterId, int authorId, long timeStarted, long latestCommittedTxWhenStarted, long timeCommitted, int lockSession) {
        this.additionalHeader = additionalHeader;
        this.masterId = masterId;
        this.authorId = authorId;
        this.timeStarted = timeStarted;
        this.latestCommittedTxWhenStarted = latestCommittedTxWhenStarted;
        this.timeCommitted = timeCommitted;
        this.lockSessionIdentifier = lockSession;
    }

    @Override
    public boolean accept(Visitor<StorageCommand, IOException> visitor) throws IOException {
        for (StorageCommand command : this.commands) {
            if (!visitor.visit((Object)command)) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte[] additionalHeader() {
        return this.additionalHeader;
    }

    @Override
    public int getMasterId() {
        return this.masterId;
    }

    @Override
    public int getAuthorId() {
        return this.authorId;
    }

    @Override
    public long getTimeStarted() {
        return this.timeStarted;
    }

    @Override
    public long getLatestCommittedTxWhenStarted() {
        return this.latestCommittedTxWhenStarted;
    }

    @Override
    public long getTimeCommitted() {
        return this.timeCommitted;
    }

    @Override
    public int getLockSessionId() {
        return this.lockSessionIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhysicalTransactionRepresentation that = (PhysicalTransactionRepresentation)o;
        if (this.authorId != that.authorId) {
            return false;
        }
        if (this.latestCommittedTxWhenStarted != that.latestCommittedTxWhenStarted) {
            return false;
        }
        if (this.masterId != that.masterId) {
            return false;
        }
        if (this.timeStarted != that.timeStarted) {
            return false;
        }
        if (!Arrays.equals(this.additionalHeader, that.additionalHeader)) {
            return false;
        }
        return this.commands.equals(that.commands);
    }

    public int hashCode() {
        int result = this.commands.hashCode();
        result = 31 * result + (this.additionalHeader != null ? Arrays.hashCode(this.additionalHeader) : 0);
        result = 31 * result + this.masterId;
        result = 31 * result + this.authorId;
        result = 31 * result + (int)(this.timeStarted ^ this.timeStarted >>> 32);
        result = 31 * result + (int)(this.latestCommittedTxWhenStarted ^ this.latestCommittedTxWhenStarted >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName() + "[");
        builder.append("masterId:" + this.masterId + ",");
        builder.append("authorId:" + this.authorId + ",");
        builder.append("timeStarted:" + this.timeStarted + ",");
        builder.append("latestCommittedTxWhenStarted:" + this.latestCommittedTxWhenStarted + ",");
        builder.append("timeCommitted:" + this.timeCommitted + ",");
        builder.append("lockSession:" + this.lockSessionIdentifier + ",");
        builder.append("additionalHeader:" + Arrays.toString(this.additionalHeader));
        for (StorageCommand command : this.commands) {
            builder.append("\n" + command);
        }
        return builder.toString();
    }
}

