/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.LegacyIndexProviderLookup;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.spi.legacyindex.IndexImplementation;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StoreFileMetadata;

public class NeoStoreFileListing {
    private final File storeDir;
    private final LabelScanStore labelScanStore;
    private final IndexingService indexingService;
    private final LegacyIndexProviderLookup legacyIndexProviders;
    private final StorageEngine storageEngine;
    private final Function<File, StoreFileMetadata> toNotAStoreTypeFile = file -> new StoreFileMetadata((File)file, Optional.empty(), 1);

    public NeoStoreFileListing(File storeDir, LabelScanStore labelScanStore, IndexingService indexingService, LegacyIndexProviderLookup legacyIndexProviders, StorageEngine storageEngine) {
        this.storeDir = storeDir;
        this.labelScanStore = labelScanStore;
        this.indexingService = indexingService;
        this.legacyIndexProviders = legacyIndexProviders;
        this.storageEngine = storageEngine;
    }

    public ResourceIterator<StoreFileMetadata> listStoreFiles(boolean includeLogs) throws IOException {
        ArrayList<StoreFileMetadata> files = new ArrayList<StoreFileMetadata>();
        this.gatherNonRecordStores(files, includeLogs);
        this.gatherNeoStoreFiles(files);
        Resource labelScanStoreSnapshot = this.gatherLabelScanStoreFiles(files);
        Resource schemaIndexSnapshots = this.gatherSchemaIndexFiles(files);
        Resource legacyIndexSnapshots = this.gatherLegacyIndexFiles(files);
        return Iterators.resourceIterator(files.iterator(), (Resource)new MultiResource(Arrays.asList(labelScanStoreSnapshot, schemaIndexSnapshots, legacyIndexSnapshots)));
    }

    private void gatherNonRecordStores(Collection<StoreFileMetadata> files, boolean includeLogs) {
        File[] storeFiles = this.storeDir.listFiles();
        if (storeFiles == null) {
            return;
        }
        for (File file : storeFiles) {
            if (file.getName().equals("index.db")) {
                files.add(this.toNotAStoreTypeFile.apply(file));
                continue;
            }
            if (!includeLogs || !this.transactionLogFile(file.getName())) continue;
            files.add(this.toNotAStoreTypeFile.apply(file));
        }
    }

    private Resource gatherLegacyIndexFiles(Collection<StoreFileMetadata> files) throws IOException {
        ArrayList<ResourceIterator<File>> snapshots = new ArrayList<ResourceIterator<File>>();
        for (IndexImplementation indexProvider : this.legacyIndexProviders.all()) {
            ResourceIterator<File> snapshot = indexProvider.listStoreFiles();
            snapshots.add(snapshot);
            snapshot.stream().map(this.toNotAStoreTypeFile).collect(Collectors.toCollection(() -> files));
        }
        return new MultiResource(snapshots);
    }

    private Resource gatherSchemaIndexFiles(Collection<StoreFileMetadata> targetFiles) throws IOException {
        ResourceIterator<File> snapshot = this.indexingService.snapshotStoreFiles();
        snapshot.stream().map(this.toNotAStoreTypeFile).collect(Collectors.toCollection(() -> targetFiles));
        return snapshot;
    }

    private Resource gatherLabelScanStoreFiles(Collection<StoreFileMetadata> targetFiles) throws IOException {
        ResourceIterator<File> snapshot = this.labelScanStore.snapshotStoreFiles();
        snapshot.stream().map(this.toNotAStoreTypeFile).collect(Collectors.toCollection(() -> targetFiles));
        return snapshot;
    }

    private void gatherNeoStoreFiles(Collection<StoreFileMetadata> targetFiles) {
        targetFiles.addAll(this.storageEngine.listStorageFiles());
    }

    private boolean transactionLogFile(String name) {
        return name.startsWith("neostore.transaction") && !name.endsWith(".active");
    }

    private static final class MultiResource
    implements Resource {
        private final Collection<? extends Resource> snapshots;

        private MultiResource(Collection<? extends Resource> resources) {
            this.snapshots = resources;
        }

        public void close() {
            RuntimeException exception = null;
            for (Resource resource : this.snapshots) {
                try {
                    resource.close();
                }
                catch (RuntimeException e) {
                    exception = e;
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }
}

