/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.time.Clock;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.Listeners;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.logging.Log;

public class AvailabilityGuard {
    public static final String DATABASE_AVAILABLE_MSG = "Fulfilling of requirement makes database available: ";
    public static final String DATABASE_UNAVAILABLE_MSG = "Requirement makes database unavailable: ";
    private final AtomicInteger requirementCount = new AtomicInteger(0);
    private final Set<AvailabilityRequirement> blockingRequirements = new CopyOnWriteArraySet<AvailabilityRequirement>();
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private final Listeners<AvailabilityListener> listeners = new Listeners();
    private final Clock clock;
    private final Log log;
    public static final Function<AvailabilityRequirement, String> DESCRIPTION = AvailabilityRequirement::description;

    public static AvailabilityRequirement availabilityRequirement(final String descriptionWhenBlocking) {
        return new AvailabilityRequirement(){

            @Override
            public String description() {
                return descriptionWhenBlocking;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                AvailabilityRequirement that = (AvailabilityRequirement)o;
                return descriptionWhenBlocking == null ? that.description() == null : descriptionWhenBlocking.equals(that.description());
            }

            public int hashCode() {
                return descriptionWhenBlocking != null ? descriptionWhenBlocking.hashCode() : 0;
            }
        };
    }

    public AvailabilityGuard(Clock clock, Log log) {
        this.clock = clock;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void require(AvailabilityRequirement requirement) {
        if (!this.blockingRequirements.add(requirement)) {
            return;
        }
        AtomicInteger atomicInteger = this.requirementCount;
        synchronized (atomicInteger) {
            if (this.requirementCount.getAndIncrement() == 0 && !this.isShutdown.get()) {
                this.log.info(DATABASE_UNAVAILABLE_MSG + requirement.description());
                this.listeners.notify(AvailabilityListener::unavailable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fulfill(AvailabilityRequirement requirement) {
        if (!this.blockingRequirements.remove(requirement)) {
            return;
        }
        AtomicInteger atomicInteger = this.requirementCount;
        synchronized (atomicInteger) {
            if (this.requirementCount.getAndDecrement() == 1 && !this.isShutdown.get()) {
                this.log.info(DATABASE_AVAILABLE_MSG + requirement.description());
                this.listeners.notify(AvailabilityListener::available);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        AtomicInteger atomicInteger = this.requirementCount;
        synchronized (atomicInteger) {
            if (this.isShutdown.getAndSet(true)) {
                return;
            }
            if (this.requirementCount.get() == 0) {
                this.listeners.notify(AvailabilityListener::unavailable);
            }
        }
    }

    public boolean isAvailable() {
        return this.availability() == Availability.AVAILABLE;
    }

    public boolean isShutdown() {
        return this.availability() == Availability.SHUTDOWN;
    }

    public boolean isAvailable(long millis) {
        return this.availability(millis) == Availability.AVAILABLE;
    }

    public void checkAvailable() throws UnavailableException {
        this.await(0L);
    }

    public void await(long millis) throws UnavailableException {
        Availability availability = this.availability(millis);
        if (availability == Availability.AVAILABLE) {
            return;
        }
        String description = availability == Availability.UNAVAILABLE ? "Timeout waiting for database to become available and allow new transactions. Waited " + Format.duration(millis) + ". " + this.describeWhoIsBlocking() : "Database not available because it's shutting down";
        throw new UnavailableException(description);
    }

    private Availability availability() {
        if (this.isShutdown.get()) {
            return Availability.SHUTDOWN;
        }
        int count = this.requirementCount.get();
        if (count == 0) {
            return Availability.AVAILABLE;
        }
        assert (count > 0);
        return Availability.UNAVAILABLE;
    }

    private Availability availability(long millis) {
        Availability availability = this.availability();
        if (availability != Availability.UNAVAILABLE) {
            return availability;
        }
        long timeout = this.clock.millis() + millis;
        do {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                break;
            }
        } while ((availability = this.availability()) == Availability.UNAVAILABLE && this.clock.millis() < timeout);
        return availability;
    }

    public void addListener(AvailabilityListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(AvailabilityListener listener) {
        this.listeners.remove(listener);
    }

    public String describeWhoIsBlocking() {
        if (this.blockingRequirements.size() > 0 || this.requirementCount.get() > 0) {
            String causes = Iterables.join((String)", ", (Iterable)Iterables.map(DESCRIPTION, this.blockingRequirements));
            return this.requirementCount.get() + " reasons for blocking: " + causes + ".";
        }
        return "No blocking components";
    }

    private static enum Availability {
        AVAILABLE,
        UNAVAILABLE,
        SHUTDOWN;

    }

    public static interface AvailabilityRequirement {
        public String description();
    }

    public static interface AvailabilityListener {
        public void available();

        public void unavailable();
    }

    public class UnavailableException
    extends Exception {
        public UnavailableException(String message) {
            super(message);
        }
    }
}

