/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.concurrent.Callable;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.properties.BooleanArrayProperty;
import org.neo4j.kernel.api.properties.BooleanProperty;
import org.neo4j.kernel.api.properties.ByteArrayProperty;
import org.neo4j.kernel.api.properties.ByteProperty;
import org.neo4j.kernel.api.properties.CharArrayProperty;
import org.neo4j.kernel.api.properties.CharProperty;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.DoubleArrayProperty;
import org.neo4j.kernel.api.properties.DoubleProperty;
import org.neo4j.kernel.api.properties.FloatArrayProperty;
import org.neo4j.kernel.api.properties.FloatProperty;
import org.neo4j.kernel.api.properties.IntArrayProperty;
import org.neo4j.kernel.api.properties.IntProperty;
import org.neo4j.kernel.api.properties.LazyArrayProperty;
import org.neo4j.kernel.api.properties.LazyStringProperty;
import org.neo4j.kernel.api.properties.LongArrayProperty;
import org.neo4j.kernel.api.properties.LongProperty;
import org.neo4j.kernel.api.properties.NoProperty;
import org.neo4j.kernel.api.properties.PropertyConversion;
import org.neo4j.kernel.api.properties.ShortArrayProperty;
import org.neo4j.kernel.api.properties.ShortProperty;
import org.neo4j.kernel.api.properties.StringArrayProperty;
import org.neo4j.kernel.api.properties.StringProperty;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.StorageProperty;

public abstract class Property
implements StorageProperty {
    final int propertyKeyId;

    public static Property noNodeProperty(long nodeId, int propertyKeyId) {
        return Property.noProperty(propertyKeyId, EntityType.NODE, nodeId);
    }

    public static Property noRelationshipProperty(long relationshipId, int propertyKeyId) {
        return Property.noProperty(propertyKeyId, EntityType.RELATIONSHIP, relationshipId);
    }

    public static Property noGraphProperty(int propertyKeyId) {
        return Property.noProperty(propertyKeyId, EntityType.GRAPH, -1L);
    }

    public static Property noProperty(int propertyKeyId, EntityType type, long entityId) {
        return new NoProperty(propertyKeyId, type, entityId);
    }

    public static DefinedProperty property(int propertyKeyId, Object value) {
        return PropertyConversion.convertProperty(propertyKeyId, value);
    }

    Property(int propertyKeyId) {
        this.propertyKeyId = propertyKeyId;
    }

    @Override
    public final int propertyKeyId() {
        return this.propertyKeyId;
    }

    @Override
    public abstract boolean valueEquals(Object var1);

    @Override
    public abstract Object value() throws PropertyNotFoundException;

    @Override
    public abstract Object value(Object var1);

    @Override
    public abstract String valueAsString() throws PropertyNotFoundException;

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @Override
    public abstract boolean isDefined();

    public static DefinedProperty stringProperty(int propertyKeyId, String value) {
        return new StringProperty(propertyKeyId, value);
    }

    public static DefinedProperty lazyStringProperty(int propertyKeyId, Callable<String> producer) {
        return new LazyStringProperty(propertyKeyId, producer);
    }

    public static DefinedProperty lazyArrayProperty(int propertyKeyId, Callable<Object> producer) {
        return new LazyArrayProperty(propertyKeyId, producer);
    }

    public static DefinedProperty numberProperty(int propertyKeyId, Number number) {
        if (number instanceof Long) {
            return Property.longProperty(propertyKeyId, number.longValue());
        }
        if (number instanceof Integer) {
            return Property.intProperty(propertyKeyId, number.intValue());
        }
        if (number instanceof Double) {
            return Property.doubleProperty(propertyKeyId, number.doubleValue());
        }
        if (number instanceof Byte) {
            return Property.byteProperty(propertyKeyId, number.byteValue());
        }
        if (number instanceof Float) {
            return Property.floatProperty(propertyKeyId, number.floatValue());
        }
        if (number instanceof Short) {
            return Property.shortProperty(propertyKeyId, number.shortValue());
        }
        throw new UnsupportedOperationException("Unsupported type of Number " + number.toString());
    }

    public static DefinedProperty longProperty(int propertyKeyId, long value) {
        return new LongProperty(propertyKeyId, value);
    }

    public static DefinedProperty intProperty(int propertyKeyId, int value) {
        return new IntProperty(propertyKeyId, value);
    }

    public static DefinedProperty shortProperty(int propertyKeyId, short value) {
        return new ShortProperty(propertyKeyId, value);
    }

    public static DefinedProperty byteProperty(int propertyKeyId, byte value) {
        return new ByteProperty(propertyKeyId, value);
    }

    public static DefinedProperty booleanProperty(int propertyKeyId, boolean value) {
        return new BooleanProperty(propertyKeyId, value);
    }

    public static DefinedProperty charProperty(int propertyKeyId, char value) {
        return new CharProperty(propertyKeyId, value);
    }

    public static DefinedProperty doubleProperty(int propertyKeyId, double value) {
        return new DoubleProperty(propertyKeyId, value);
    }

    public static DefinedProperty floatProperty(int propertyKeyId, float value) {
        return new FloatProperty(propertyKeyId, value);
    }

    public static DefinedProperty stringArrayProperty(int propertyKeyId, String[] value) {
        return new StringArrayProperty(propertyKeyId, value);
    }

    public static DefinedProperty byteArrayProperty(int propertyKeyId, byte[] value) {
        return new ByteArrayProperty(propertyKeyId, value);
    }

    public static DefinedProperty longArrayProperty(int propertyKeyId, long[] value) {
        return new LongArrayProperty(propertyKeyId, value);
    }

    public static DefinedProperty intArrayProperty(int propertyKeyId, int[] value) {
        return new IntArrayProperty(propertyKeyId, value);
    }

    public static DefinedProperty doubleArrayProperty(int propertyKeyId, double[] value) {
        return new DoubleArrayProperty(propertyKeyId, value);
    }

    public static DefinedProperty floatArrayProperty(int propertyKeyId, float[] value) {
        return new FloatArrayProperty(propertyKeyId, value);
    }

    public static DefinedProperty booleanArrayProperty(int propertyKeyId, boolean[] value) {
        return new BooleanArrayProperty(propertyKeyId, value);
    }

    public static DefinedProperty charArrayProperty(int propertyKeyId, char[] value) {
        return new CharArrayProperty(propertyKeyId, value);
    }

    public static DefinedProperty shortArrayProperty(int propertyKeyId, short[] value) {
        return new ShortArrayProperty(propertyKeyId, value);
    }
}

