/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestGraphDatabaseFactory;

public class DiagnosticsLoggingTest {
    @Test
    public void shouldSeeExpectedDiagnostics() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        GraphDatabaseService db = new TestGraphDatabaseFactory().setInternalLogProvider((LogProvider)logProvider).newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.dump_configuration, "true").setConfig(GraphDatabaseSettings.pagecache_memory, "4M").newGraphDatabase();
        logProvider.assertContainsMessageContaining("Network information");
        logProvider.assertContainsMessageContaining("Disk space on partition");
        logProvider.assertContainsMessageContaining("Local timezone");
        logProvider.assertContainsMessageContaining("Page cache size: 4 MiB");
        for (MetaDataStore.Position position : MetaDataStore.Position.values()) {
            logProvider.assertContainsMessageContaining(position.name());
        }
        logProvider.assertContainsMessageContaining("Transaction log");
        db.shutdown();
    }
}

