/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema;

import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.api.schema.IndexQuery;

public class IndexQueryTest {
    private int propId = 0;

    @Test
    public void testExists() throws Exception {
        IndexQuery.ExistsPredicate p = IndexQuery.exists((int)this.propId);
        TestCase.assertTrue((boolean)p.test((Object)"string"));
        TestCase.assertTrue((boolean)p.test((Object)1));
        TestCase.assertTrue((boolean)p.test((Object)1.0));
        TestCase.assertTrue((boolean)p.test((Object)true));
        TestCase.assertTrue((boolean)p.test((Object)new long[]{1L}));
        TestCase.assertFalse((boolean)p.test(null));
    }

    @Test
    public void testExact() throws Exception {
        this.assertExactPredicate("string");
        this.assertExactPredicate(1);
        this.assertExactPredicate(1.0);
        this.assertExactPredicate(true);
        this.assertExactPredicate(new long[]{1L});
    }

    private void assertExactPredicate(Object value) {
        IndexQuery.ExactPredicate p = IndexQuery.exact((int)this.propId, (Object)value);
        TestCase.assertTrue((boolean)p.test(value));
        this.assertFalseForOtherThings((IndexQuery)p);
    }

    @Test
    public void testExact_ComparingBigDoublesAndLongs() {
        IndexQuery.ExactPredicate p = IndexQuery.exact((int)this.propId, (Object)0x20000000000001L);
        Assert.assertFalse((boolean)p.test((Object)9.007199254740992E15));
    }

    @Test
    public void testNumRange_FalseForIrrelevant() {
        IndexQuery.NumberRangePredicate p = IndexQuery.range((int)this.propId, (Number)11, (boolean)true, (Number)13, (boolean)true);
        this.assertFalseForOtherThings((IndexQuery)p);
    }

    @Test
    public void testNumRange_InclusiveLowerInclusiveUpper() {
        IndexQuery.NumberRangePredicate p = IndexQuery.range((int)this.propId, (Number)11, (boolean)true, (Number)13, (boolean)true);
        Assert.assertFalse((boolean)p.test((Object)10));
        Assert.assertTrue((boolean)p.test((Object)11));
        Assert.assertTrue((boolean)p.test((Object)12));
        Assert.assertTrue((boolean)p.test((Object)13));
        Assert.assertFalse((boolean)p.test((Object)14));
    }

    @Test
    public void testNumRange_ExclusiveLowerExclusiveLower() {
        IndexQuery.NumberRangePredicate p = IndexQuery.range((int)this.propId, (Number)11, (boolean)false, (Number)13, (boolean)false);
        Assert.assertFalse((boolean)p.test((Object)11));
        Assert.assertTrue((boolean)p.test((Object)12));
        Assert.assertFalse((boolean)p.test((Object)13));
    }

    @Test
    public void testNumRange_InclusiveLowerExclusiveUpper() {
        IndexQuery.NumberRangePredicate p = IndexQuery.range((int)this.propId, (Number)11, (boolean)true, (Number)13, (boolean)false);
        Assert.assertFalse((boolean)p.test((Object)10));
        Assert.assertTrue((boolean)p.test((Object)11));
        Assert.assertTrue((boolean)p.test((Object)12));
        Assert.assertFalse((boolean)p.test((Object)13));
    }

    @Test
    public void testNumRange_ExclusiveLowerInclusiveUpper() {
        IndexQuery.NumberRangePredicate p = IndexQuery.range((int)this.propId, (Number)11, (boolean)false, (Number)13, (boolean)true);
        Assert.assertFalse((boolean)p.test((Object)11));
        Assert.assertTrue((boolean)p.test((Object)12));
        Assert.assertTrue((boolean)p.test((Object)13));
        Assert.assertFalse((boolean)p.test((Object)14));
    }

    @Test
    public void testNumRange_LowerNullValue() {
        IndexQuery.NumberRangePredicate p = IndexQuery.range((int)this.propId, null, (boolean)true, (Number)13, (boolean)true);
        Assert.assertTrue((boolean)p.test((Object)10));
        Assert.assertTrue((boolean)p.test((Object)11));
        Assert.assertTrue((boolean)p.test((Object)12));
        Assert.assertTrue((boolean)p.test((Object)13));
        Assert.assertFalse((boolean)p.test((Object)14));
    }

    @Test
    public void testNumRange_UpperNullValue() {
        IndexQuery.NumberRangePredicate p = IndexQuery.range((int)this.propId, (Number)11, (boolean)true, null, (boolean)true);
        Assert.assertFalse((boolean)p.test((Object)10));
        Assert.assertTrue((boolean)p.test((Object)11));
        Assert.assertTrue((boolean)p.test((Object)12));
        Assert.assertTrue((boolean)p.test((Object)13));
        Assert.assertTrue((boolean)p.test((Object)14));
    }

    @Test
    public void testNumRange_ComparingBigDoublesAndLongs() {
        IndexQuery.NumberRangePredicate p = IndexQuery.range((int)this.propId, (Number)0x20000000000001L, (boolean)true, null, (boolean)true);
        Assert.assertFalse((boolean)p.test((Object)9.007199254740992E15));
    }

    @Test
    public void testStringRange_FalseForIrrelevant() {
        IndexQuery.StringRangePredicate p = IndexQuery.range((int)this.propId, (String)"bbb", (boolean)true, (String)"bee", (boolean)true);
        this.assertFalseForOtherThings((IndexQuery)p);
    }

    @Test
    public void testStringRange_InclusiveLowerInclusiveUpper() {
        IndexQuery.StringRangePredicate p = IndexQuery.range((int)this.propId, (String)"bbb", (boolean)true, (String)"bee", (boolean)true);
        Assert.assertFalse((boolean)p.test((Object)"bba"));
        Assert.assertTrue((boolean)p.test((Object)"bbb"));
        Assert.assertTrue((boolean)p.test((Object)"bee"));
        Assert.assertFalse((boolean)p.test((Object)"beea"));
        Assert.assertFalse((boolean)p.test((Object)"bef"));
    }

    @Test
    public void testStringRange_ExclusiveLowerInclusiveUpper() {
        IndexQuery.StringRangePredicate p = IndexQuery.range((int)this.propId, (String)"bbb", (boolean)false, (String)"bee", (boolean)true);
        Assert.assertFalse((boolean)p.test((Object)"bbb"));
        Assert.assertTrue((boolean)p.test((Object)"bbba"));
        Assert.assertTrue((boolean)p.test((Object)"bee"));
        Assert.assertFalse((boolean)p.test((Object)"beea"));
    }

    @Test
    public void testStringRange_InclusiveLowerExclusiveUpper() {
        IndexQuery.StringRangePredicate p = IndexQuery.range((int)this.propId, (String)"bbb", (boolean)true, (String)"bee", (boolean)false);
        Assert.assertFalse((boolean)p.test((Object)"bba"));
        Assert.assertTrue((boolean)p.test((Object)"bbb"));
        Assert.assertTrue((boolean)p.test((Object)"bed"));
        Assert.assertFalse((boolean)p.test((Object)"bee"));
    }

    @Test
    public void testStringRange_ExclusiveLowerExclusiveUpper() {
        IndexQuery.StringRangePredicate p = IndexQuery.range((int)this.propId, (String)"bbb", (boolean)false, (String)"bee", (boolean)false);
        Assert.assertFalse((boolean)p.test((Object)"bbb"));
        Assert.assertTrue((boolean)p.test((Object)"bbba"));
        Assert.assertTrue((boolean)p.test((Object)"bed"));
        Assert.assertFalse((boolean)p.test((Object)"bee"));
    }

    @Test
    public void testStringRange_UpperUnbounded() {
        IndexQuery.StringRangePredicate p = IndexQuery.range((int)this.propId, (String)"bbb", (boolean)false, null, (boolean)false);
        Assert.assertFalse((boolean)p.test((Object)"bbb"));
        Assert.assertTrue((boolean)p.test((Object)"bbba"));
        Assert.assertTrue((boolean)p.test((Object)"xxxxx"));
    }

    @Test
    public void testStringRange_LowerUnbounded() {
        IndexQuery.StringRangePredicate p = IndexQuery.range((int)this.propId, null, (boolean)false, (String)"bee", (boolean)false);
        Assert.assertTrue((boolean)p.test((Object)""));
        Assert.assertTrue((boolean)p.test((Object)"bed"));
        Assert.assertFalse((boolean)p.test((Object)"bee"));
    }

    @Test
    public void testStringPrefix_FalseForIrrelevant() {
        IndexQuery.StringPrefixPredicate p = IndexQuery.stringPrefix((int)this.propId, (String)"dog");
        this.assertFalseForOtherThings((IndexQuery)p);
    }

    @Test
    public void testStringPrefix_SomeValues() {
        IndexQuery.StringPrefixPredicate p = IndexQuery.stringPrefix((int)this.propId, (String)"dog");
        Assert.assertFalse((boolean)p.test((Object)"doffington"));
        Assert.assertFalse((boolean)p.test((Object)"doh, not this again!"));
        Assert.assertTrue((boolean)p.test((Object)"dog"));
        Assert.assertTrue((boolean)p.test((Object)"doggidog"));
        Assert.assertTrue((boolean)p.test((Object)"doggidogdog"));
    }

    @Test
    public void testStringContains_FalseForIrrelevant() {
        IndexQuery.StringContainsPredicate p = IndexQuery.stringContains((int)this.propId, (String)"cat");
        this.assertFalseForOtherThings((IndexQuery)p);
    }

    @Test
    public void testStringContains_SomeValues() {
        IndexQuery.StringContainsPredicate p = IndexQuery.stringContains((int)this.propId, (String)"cat");
        Assert.assertFalse((boolean)p.test((Object)"dog"));
        Assert.assertFalse((boolean)p.test((Object)"cameraman"));
        Assert.assertTrue((boolean)p.test((Object)"cat"));
        Assert.assertTrue((boolean)p.test((Object)"bobcat"));
        Assert.assertTrue((boolean)p.test((Object)"scatman"));
    }

    @Test
    public void testStringSuffix_FalseForIrrelevant() {
        IndexQuery.StringSuffixPredicate p = IndexQuery.stringSuffix((int)this.propId, (String)"less");
        this.assertFalseForOtherThings((IndexQuery)p);
    }

    @Test
    public void testStringSuffix_SomeValues() {
        IndexQuery.StringSuffixPredicate p = IndexQuery.stringSuffix((int)this.propId, (String)"less");
        Assert.assertFalse((boolean)p.test((Object)"lesser being"));
        Assert.assertFalse((boolean)p.test((Object)"make less noise please..."));
        Assert.assertTrue((boolean)p.test((Object)"less"));
        Assert.assertTrue((boolean)p.test((Object)"clueless"));
        Assert.assertTrue((boolean)p.test((Object)"cluelessly clueless"));
    }

    private void assertFalseForOtherThings(IndexQuery p) {
        TestCase.assertFalse((boolean)p.test((Object)"other string"));
        TestCase.assertFalse((boolean)p.test((Object)"string1"));
        TestCase.assertFalse((boolean)p.test((Object)""));
        TestCase.assertFalse((boolean)p.test((Object)-1));
        TestCase.assertFalse((boolean)p.test((Object)-1.0));
        TestCase.assertFalse((boolean)p.test((Object)false));
        TestCase.assertFalse((boolean)p.test((Object)new long[]{-1L}));
        TestCase.assertFalse((boolean)p.test(null));
    }
}

