/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.mockito.Mockito;
import org.neo4j.helpers.FutureAdapter;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class SchemaIndexTestHelper {
    public static KernelExtensionFactory<SingleInstanceSchemaIndexProviderFactoryDependencies> singleInstanceSchemaIndexProviderFactory(String key, SchemaIndexProvider provider) {
        return new SingleInstanceSchemaIndexProviderFactory(key, provider);
    }

    public static IndexProxy mockIndexProxy() throws IOException {
        IndexProxy result = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)result.drop()).thenReturn((Object)FutureAdapter.VOID);
        Mockito.when((Object)result.close()).thenReturn((Object)FutureAdapter.VOID);
        return result;
    }

    public static <T> T awaitFuture(Future<T> future) {
        try {
            return future.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new RuntimeException(e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean awaitLatch(CountDownLatch latch) {
        try {
            return latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new RuntimeException(e);
        }
    }

    public static void awaitIndexOnline(ReadOperations readOperations, IndexDescriptor index) throws IndexNotFoundKernelException {
        long start = System.currentTimeMillis();
        while (readOperations.indexGetState(index) != InternalIndexState.ONLINE) {
            if (start + 10000L >= System.currentTimeMillis()) continue;
            throw new RuntimeException("Index didn't come online within a reasonable time.");
        }
    }

    private static class SingleInstanceSchemaIndexProviderFactory
    extends KernelExtensionFactory<SingleInstanceSchemaIndexProviderFactoryDependencies> {
        private final SchemaIndexProvider provider;

        private SingleInstanceSchemaIndexProviderFactory(String key, SchemaIndexProvider provider) {
            super(key);
            this.provider = provider;
        }

        public Lifecycle newInstance(KernelContext context, SingleInstanceSchemaIndexProviderFactoryDependencies dependencies) throws Throwable {
            return this.provider;
        }
    }

    public static interface SingleInstanceSchemaIndexProviderFactoryDependencies {
        public Config config();
    }
}

