/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.inmemory;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.impl.api.PropertyValueComparison;
import org.neo4j.kernel.impl.api.index.inmemory.HashBasedIndexSampler;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexImplementation;
import org.neo4j.storageengine.api.schema.IndexSampler;

class HashBasedIndex
extends InMemoryIndexImplementation {
    private Map<List<Object>, Set<Long>> data;

    HashBasedIndex() {
    }

    public Map<List<Object>, Set<Long>> data() {
        if (this.data == null) {
            throw new IllegalStateException("Index has not been created, or has been dropped.");
        }
        return this.data;
    }

    public synchronized String toString() {
        return this.getClass().getSimpleName() + this.data;
    }

    @Override
    synchronized void initialize() {
        this.data = new HashMap<List<Object>, Set<Long>>();
    }

    @Override
    synchronized void drop() {
        this.data = null;
    }

    @Override
    synchronized PrimitiveLongIterator doIndexSeek(Object ... propertyValues) {
        Set<Long> nodes = this.data().get(Arrays.asList(propertyValues));
        return nodes == null ? PrimitiveLongCollections.emptyIterator() : PrimitiveLongCollections.toPrimitiveIterator(nodes.iterator());
    }

    private synchronized PrimitiveLongIterator rangeSeekByNumberInclusive(Number lower, Number upper) {
        HashSet nodeIds = new HashSet();
        for (Map.Entry<List<Object>, Set<Long>> entry : this.data.entrySet()) {
            boolean upperFilter;
            Object key = entry.getKey().get(0);
            if (!PropertyValueComparison.SuperType.NUMBER.isSuperTypeOf(key)) continue;
            boolean lowerFilter = lower == null || PropertyValueComparison.COMPARE_VALUES.compare(key, (Object)lower) >= 0;
            boolean bl = upperFilter = upper == null || PropertyValueComparison.COMPARE_VALUES.compare(key, (Object)upper) <= 0;
            if (!lowerFilter || !upperFilter) continue;
            nodeIds.addAll(entry.getValue());
        }
        return PrimitiveLongCollections.toPrimitiveIterator(nodeIds.iterator());
    }

    private synchronized PrimitiveLongIterator rangeSeekByString(String lower, boolean includeLower, String upper, boolean includeUpper) {
        HashSet nodeIds = new HashSet();
        for (Map.Entry<List<Object>, Set<Long>> entry : this.data.entrySet()) {
            boolean upperFilter;
            int cmp;
            boolean lowerFilter;
            Object key = entry.getKey().get(0);
            if (!PropertyValueComparison.SuperType.STRING.isSuperTypeOf(key)) continue;
            if (lower == null) {
                lowerFilter = true;
            } else {
                cmp = PropertyValueComparison.COMPARE_VALUES.compare(key, (Object)lower);
                boolean bl = lowerFilter = includeLower && cmp >= 0 || cmp > 0;
            }
            if (upper == null) {
                upperFilter = true;
            } else {
                cmp = PropertyValueComparison.COMPARE_VALUES.compare(key, (Object)upper);
                boolean bl = upperFilter = includeUpper && cmp <= 0 || cmp < 0;
            }
            if (!lowerFilter || !upperFilter) continue;
            nodeIds.addAll(entry.getValue());
        }
        return PrimitiveLongCollections.toPrimitiveIterator(nodeIds.iterator());
    }

    private synchronized PrimitiveLongIterator rangeSeekByPrefix(String prefix) {
        return this.stringSearch(entry -> entry.startsWith(prefix));
    }

    private synchronized PrimitiveLongIterator containsString(String exactTerm) {
        return this.stringSearch(entry -> entry.contains(exactTerm));
    }

    private PrimitiveLongIterator endsWith(String suffix) {
        return this.stringSearch(entry -> entry.endsWith(suffix));
    }

    private synchronized PrimitiveLongIterator scan() {
        Iterable all = Iterables.flattenIterable(this.data.values());
        return PrimitiveLongCollections.toPrimitiveIterator(all.iterator());
    }

    @Override
    synchronized boolean doAdd(long nodeId, boolean applyIdempotently, Object ... propertyValue) {
        Set<Long> nodes = this.data().get(Arrays.asList(propertyValue));
        if (nodes == null) {
            nodes = new HashSet<Long>();
            this.data().put(Arrays.asList(propertyValue), nodes);
        }
        return nodes.add(nodeId);
    }

    @Override
    synchronized void doRemove(long nodeId, Object ... propertyValues) {
        Set<Long> nodes = this.data().get(Arrays.asList(propertyValues));
        if (nodes != null) {
            nodes.remove(nodeId);
        }
    }

    @Override
    synchronized void remove(long nodeId) {
        for (Set<Long> nodes : this.data().values()) {
            nodes.remove(nodeId);
        }
    }

    @Override
    synchronized void iterateAll(InMemoryIndexImplementation.IndexEntryIterator iterator) throws Exception {
        for (Map.Entry<List<Object>, Set<Long>> entry : this.data().entrySet()) {
            iterator.visitEntry(entry.getKey(), entry.getValue());
        }
    }

    public synchronized long maxCount() {
        return this.ids().size();
    }

    public synchronized Iterator<Long> iterator() {
        return this.ids().iterator();
    }

    private Collection<Long> ids() {
        HashSet<Long> allIds = new HashSet<Long>();
        for (Set<Long> someIds : this.data().values()) {
            allIds.addAll(someIds);
        }
        return allIds;
    }

    @Override
    synchronized InMemoryIndexImplementation snapshot() {
        HashBasedIndex snapshot = new HashBasedIndex();
        snapshot.initialize();
        for (Map.Entry<List<Object>, Set<Long>> entry : this.data().entrySet()) {
            snapshot.data().put(entry.getKey(), new HashSet(entry.getValue()));
        }
        return snapshot;
    }

    @Override
    protected synchronized long doCountIndexedNodes(long nodeId, Object ... propertyValues) {
        Set<Long> candidates = this.data().get(Arrays.asList(propertyValues));
        return candidates != null && candidates.contains(nodeId) ? 1L : 0L;
    }

    public synchronized IndexSampler createSampler() {
        return new HashBasedIndexSampler(this.data);
    }

    public PrimitiveLongIterator query(IndexQuery ... predicates) {
        if (predicates.length > 1) {
            Object[] values = new Object[predicates.length];
            for (int i = 0; i < predicates.length; ++i) {
                assert (predicates[i].type() == IndexQuery.IndexQueryType.exact) : "composite indexes only supported for seek";
                values[i] = ((IndexQuery.ExactPredicate)predicates[i]).value();
            }
            return this.seek(values);
        }
        assert (predicates.length == 1) : "composite indexes not yet supported, except for seek on all properties";
        IndexQuery predicate = predicates[0];
        switch (predicate.type()) {
            case exists: {
                return this.scan();
            }
            case exact: {
                return this.seek(((IndexQuery.ExactPredicate)predicate).value());
            }
            case rangeNumeric: {
                IndexQuery.NumberRangePredicate np = (IndexQuery.NumberRangePredicate)predicate;
                return this.rangeSeekByNumberInclusive(np.from(), np.to());
            }
            case rangeString: {
                IndexQuery.StringRangePredicate srp = (IndexQuery.StringRangePredicate)predicate;
                return this.rangeSeekByString(srp.from(), srp.fromInclusive(), srp.to(), srp.toInclusive());
            }
            case stringPrefix: {
                IndexQuery.StringPrefixPredicate spp = (IndexQuery.StringPrefixPredicate)predicate;
                return this.rangeSeekByPrefix(spp.prefix());
            }
            case stringContains: {
                IndexQuery.StringContainsPredicate scp = (IndexQuery.StringContainsPredicate)predicate;
                return this.containsString(scp.contains());
            }
            case stringSuffix: {
                IndexQuery.StringSuffixPredicate ssp = (IndexQuery.StringSuffixPredicate)predicate;
                return this.endsWith(ssp.suffix());
            }
        }
        throw new RuntimeException("Unsupported query: " + Arrays.toString(predicates));
    }

    private PrimitiveLongIterator stringSearch(StringFilter filter) {
        HashSet nodeIds = new HashSet();
        for (Map.Entry<List<Object>, Set<Long>> entry : this.data.entrySet()) {
            Object key = entry.getKey().get(0);
            if (!(key instanceof String) || !filter.test((String)key)) continue;
            nodeIds.addAll(entry.getValue());
        }
        return PrimitiveLongCollections.toPrimitiveIterator(nodeIds.iterator());
    }

    private static interface StringFilter {
        public boolean test(String var1);
    }
}

