/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.inmemory;

import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.kernel.api.index.ArrayEncoder;
import org.neo4j.storageengine.api.schema.IndexReader;

abstract class InMemoryIndexImplementation
implements IndexReader,
BoundedIterable<Long> {
    InMemoryIndexImplementation() {
    }

    abstract void initialize();

    abstract void drop();

    public final PrimitiveLongIterator seek(Object ... values) {
        return this.doIndexSeek(InMemoryIndexImplementation.encode(values));
    }

    final boolean add(long nodeId, boolean applyIdempotently, Object ... propertyValues) {
        return this.doAdd(nodeId, applyIdempotently, InMemoryIndexImplementation.encode(propertyValues));
    }

    final void remove(long nodeId, Object ... propertyValues) {
        this.doRemove(nodeId, InMemoryIndexImplementation.encode(propertyValues));
    }

    public final long countIndexedNodes(long nodeId, Object ... propertyValues) {
        return this.doCountIndexedNodes(nodeId, InMemoryIndexImplementation.encode(propertyValues));
    }

    protected abstract long doCountIndexedNodes(long var1, Object ... var3);

    abstract PrimitiveLongIterator doIndexSeek(Object ... var1);

    abstract boolean doAdd(long var1, boolean var3, Object ... var4);

    abstract void doRemove(long var1, Object ... var3);

    abstract void remove(long var1);

    abstract void iterateAll(IndexEntryIterator var1) throws Exception;

    public void close() {
    }

    private static Object[] encode(Object ... propertyValues) {
        for (int i = 0; i < propertyValues.length; ++i) {
            if (propertyValues[i] instanceof Number) {
                propertyValues[i] = ((Number)propertyValues[i]).doubleValue();
            }
            if (propertyValues[i] instanceof Character) {
                propertyValues[i] = propertyValues[i].toString();
            }
            if (!propertyValues[i].getClass().isArray()) continue;
            propertyValues[i] = new ArrayKey(ArrayEncoder.encode((Object)propertyValues[i]));
        }
        return propertyValues;
    }

    abstract InMemoryIndexImplementation snapshot();

    protected static interface IndexEntryIterator {
        public void visitEntry(Object var1, Set<Long> var2) throws Exception;
    }

    static class ArrayKey {
        private final String arrayValue;

        private ArrayKey(String arrayValue) {
            this.arrayValue = arrayValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArrayKey other = (ArrayKey)o;
            return other.arrayValue.equals(this.arrayValue);
        }

        public int hashCode() {
            return this.arrayValue != null ? this.arrayValue.hashCode() : 0;
        }
    }
}

