/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.Arrays;
import java.util.Iterator;
import junit.framework.TestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.storageengine.api.Token;

public class PropertyIT
extends KernelIntegrationTest {
    @Test
    public void shouldBeAbleToSetAndReadLargeByteArray() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long nodeId = statement.dataWriteOperations().nodeCreate();
        int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("clown");
        DefinedProperty property = Property.byteArrayProperty((int)propertyKeyId, (byte[])new byte[100000]);
        statement.dataWriteOperations().nodeSetProperty(nodeId, property);
        this.commit();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        readOperations.nodeGetProperty(nodeId, propertyKeyId);
    }

    @Test
    public void shouldSetNodePropertyValue() throws Exception {
        String value = "bozo";
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long nodeId = statement.dataWriteOperations().nodeCreate();
        int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("clown");
        statement.dataWriteOperations().nodeSetProperty(nodeId, Property.stringProperty((int)propertyKeyId, (String)value));
        Assert.assertEquals((Object)value, (Object)statement.readOperations().nodeGetProperty(nodeId, propertyKeyId));
        this.commit();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        Assert.assertEquals((Object)value, (Object)readOperations.nodeGetProperty(nodeId, propertyKeyId));
    }

    @Test
    public void shouldRemoveSetNodeProperty() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long nodeId = statement.dataWriteOperations().nodeCreate();
        int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("clown");
        statement.dataWriteOperations().nodeSetProperty(nodeId, Property.stringProperty((int)propertyKeyId, (String)"bozo"));
        statement.dataWriteOperations().nodeRemoveProperty(nodeId, propertyKeyId);
        Assert.assertThat((Object)statement.readOperations().nodeGetProperty(nodeId, propertyKeyId), (Matcher)Matchers.nullValue());
        this.commit();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        Assert.assertThat((Object)readOperations.nodeGetProperty(nodeId, propertyKeyId), (Matcher)Matchers.nullValue());
    }

    @Test
    public void shouldRemoveSetNodePropertyAcrossTransactions() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long nodeId = statement.dataWriteOperations().nodeCreate();
        int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("clown");
        statement.dataWriteOperations().nodeSetProperty(nodeId, Property.stringProperty((int)propertyKeyId, (String)"bozo"));
        this.commit();
        statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        Object previous = statement.dataWriteOperations().nodeRemoveProperty(nodeId, propertyKeyId).value();
        Assert.assertEquals((Object)"bozo", (Object)previous);
        Assert.assertThat((Object)statement.readOperations().nodeGetProperty(nodeId, propertyKeyId), (Matcher)Matchers.nullValue());
        this.commit();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        Assert.assertThat((Object)readOperations.nodeGetProperty(nodeId, propertyKeyId), (Matcher)Matchers.nullValue());
    }

    @Test
    public void shouldRemoveSetExistingProperty() throws Exception {
        this.dbWithNoCache();
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long nodeId = statement.dataWriteOperations().nodeCreate();
        int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("clown");
        statement.dataWriteOperations().nodeSetProperty(nodeId, Property.stringProperty((int)propertyKeyId, (String)"bozo"));
        this.commit();
        DefinedProperty newProperty = Property.stringProperty((int)propertyKeyId, (String)"ozob");
        Statement statement2 = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        statement2.dataWriteOperations().nodeRemoveProperty(nodeId, propertyKeyId);
        statement2.dataWriteOperations().nodeSetProperty(nodeId, newProperty);
        Assert.assertThat((Object)statement2.readOperations().nodeGetProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.equalTo((Object)newProperty.value()));
        this.commit();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        Assert.assertThat((Object)readOperations.nodeGetProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.equalTo((Object)newProperty.value()));
        Assert.assertThat((Object)PrimitiveIntCollections.toList((PrimitiveIntIterator)readOperations.nodeGetPropertyKeys(nodeId)), (Matcher)CoreMatchers.equalTo(Arrays.asList(newProperty.propertyKeyId())));
    }

    @Test
    public void shouldSilentlyNotRemoveMissingNodeProperty() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long nodeId = statement.dataWriteOperations().nodeCreate();
        int propertyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("clown");
        this.commit();
        statement = this.dataWriteOperationsInNewTransaction();
        Property result = statement.nodeRemoveProperty(nodeId, propertyId);
        Assert.assertFalse((String)"Return no property if removing missing", (boolean)result.isDefined());
    }

    @Test
    public void nodeHasPropertyIfSet() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long nodeId = statement.dataWriteOperations().nodeCreate();
        int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("clown");
        statement.dataWriteOperations().nodeSetProperty(nodeId, Property.stringProperty((int)propertyKeyId, (String)"bozo"));
        Assert.assertThat((Object)statement.readOperations().nodeHasProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)statement.readOperations().nodeGetProperty(nodeId, propertyKeyId), (Matcher)Matchers.notNullValue());
        this.commit();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        Assert.assertThat((Object)readOperations.nodeHasProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)readOperations.nodeGetProperty(nodeId, propertyKeyId), (Matcher)Matchers.notNullValue());
    }

    @Test
    public void nodeHasNotPropertyIfUnset() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long nodeId = statement.dataWriteOperations().nodeCreate();
        int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("clown");
        Assert.assertThat((Object)statement.readOperations().nodeHasProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)statement.readOperations().nodeGetProperty(nodeId, propertyKeyId), (Matcher)Matchers.nullValue());
        this.commit();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        Assert.assertThat((Object)readOperations.nodeHasProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)readOperations.nodeGetProperty(nodeId, propertyKeyId), (Matcher)Matchers.nullValue());
    }

    @Test
    public void shouldRollbackSetNodePropertyValue() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long nodeId = statement.dataWriteOperations().nodeCreate();
        int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("clown");
        this.commit();
        DataWriteOperations dataWriteOperations = this.dataWriteOperationsInNewTransaction();
        dataWriteOperations.nodeSetProperty(nodeId, Property.stringProperty((int)propertyKeyId, (String)"bozo"));
        this.rollback();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        Assert.assertThat((Object)readOperations.nodeHasProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)readOperations.nodeGetProperty(nodeId, propertyKeyId), (Matcher)Matchers.nullValue());
    }

    @Test
    public void shouldUpdateNodePropertyValue() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long nodeId = statement.dataWriteOperations().nodeCreate();
        int propertyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("clown");
        statement.dataWriteOperations().nodeSetProperty(nodeId, Property.stringProperty((int)propertyId, (String)"bozo"));
        this.commit();
        DataWriteOperations dataWriteOperations = this.dataWriteOperationsInNewTransaction();
        dataWriteOperations.nodeSetProperty(nodeId, Property.intProperty((int)propertyId, (int)42));
        this.commit();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        Assert.assertEquals((Object)42, (Object)readOperations.nodeGetProperty(nodeId, propertyId));
    }

    @Test
    public void shouldListAllPropertyKeys() throws Exception {
        this.dbWithNoCache();
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        int prop1 = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("prop1");
        int prop2 = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("prop2");
        Iterator propIdsBeforeCommit = statement.readOperations().propertyKeyGetAllTokens();
        Assert.assertThat((Object)Iterators.asCollection((Iterator)propIdsBeforeCommit), (Matcher)IsCollectionContaining.hasItems((Object[])new Token[]{new Token("prop1", prop1), new Token("prop2", prop2)}));
        this.commit();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        Iterator propIdsAfterCommit = readOperations.propertyKeyGetAllTokens();
        Assert.assertThat((Object)Iterators.asCollection((Iterator)propIdsAfterCommit), (Matcher)IsCollectionContaining.hasItems((Object[])new Token[]{new Token("prop1", prop1), new Token("prop2", prop2)}));
    }

    @Test
    public void shouldNotAllowModifyingPropertiesOnDeletedNode() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        int prop1 = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("prop1");
        long node = statement.dataWriteOperations().nodeCreate();
        statement.dataWriteOperations().nodeSetProperty(node, Property.stringProperty((int)prop1, (String)"As"));
        statement.dataWriteOperations().nodeDelete(node);
        try {
            statement.dataWriteOperations().nodeRemoveProperty(node, prop1);
            TestCase.fail((String)"Should have failed.");
        }
        catch (EntityNotFoundException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)("Unable to load NODE with id " + node + ".")));
        }
    }

    @Test
    public void shouldNotAllowModifyingPropertiesOnDeletedRelationship() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        int prop1 = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("prop1");
        int type = statement.tokenWriteOperations().relationshipTypeGetOrCreateForName("RELATED");
        long startNodeId = statement.dataWriteOperations().nodeCreate();
        long endNodeId = statement.dataWriteOperations().nodeCreate();
        long rel = statement.dataWriteOperations().relationshipCreate(type, startNodeId, endNodeId);
        statement.dataWriteOperations().relationshipSetProperty(rel, Property.stringProperty((int)prop1, (String)"As"));
        statement.dataWriteOperations().relationshipDelete(rel);
        try {
            statement.dataWriteOperations().relationshipRemoveProperty(rel, prop1);
            TestCase.fail((String)"Should have failed.");
        }
        catch (EntityNotFoundException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)("Unable to load RELATIONSHIP with id " + rel + ".")));
        }
    }

    @Test
    public void shouldBeAbleToRemoveResetAndTwiceRemovePropertyOnNode() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        int prop = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("foo");
        long node = statement.dataWriteOperations().nodeCreate();
        statement.dataWriteOperations().nodeSetProperty(node, Property.property((int)prop, (Object)"bar"));
        this.commit();
        DataWriteOperations dataWriteOperations = this.dataWriteOperationsInNewTransaction();
        dataWriteOperations.nodeRemoveProperty(node, prop);
        dataWriteOperations.nodeSetProperty(node, Property.property((int)prop, (Object)"bar"));
        dataWriteOperations.nodeRemoveProperty(node, prop);
        dataWriteOperations.nodeRemoveProperty(node, prop);
        this.commit();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        Assert.assertThat((Object)readOperations.nodeGetProperty(node, prop), (Matcher)Matchers.nullValue());
    }

    @Test
    public void shouldBeAbleToRemoveResetAndTwiceRemovePropertyOnRelationship() throws Exception {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        int prop = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("foo");
        int type = statement.tokenWriteOperations().relationshipTypeGetOrCreateForName("RELATED");
        long startNodeId = statement.dataWriteOperations().nodeCreate();
        long endNodeId = statement.dataWriteOperations().nodeCreate();
        long rel = statement.dataWriteOperations().relationshipCreate(type, startNodeId, endNodeId);
        statement.dataWriteOperations().relationshipSetProperty(rel, Property.property((int)prop, (Object)"bar"));
        this.commit();
        DataWriteOperations dataWriteOperations = this.dataWriteOperationsInNewTransaction();
        dataWriteOperations.relationshipRemoveProperty(rel, prop);
        dataWriteOperations.relationshipSetProperty(rel, Property.property((int)prop, (Object)"bar"));
        dataWriteOperations.relationshipRemoveProperty(rel, prop);
        dataWriteOperations.relationshipRemoveProperty(rel, prop);
        this.commit();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        Assert.assertThat((Object)readOperations.relationshipGetProperty(rel, prop), (Matcher)Matchers.nullValue());
    }
}

