/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.legacyindex.AutoIndexing;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.StateHandlingStatementOperations;
import org.neo4j.kernel.impl.api.StatementOperationsTestHelper;
import org.neo4j.kernel.impl.api.legacyindex.InternalAutoIndexing;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.StubCursors;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.index.LegacyIndexStore;
import org.neo4j.storageengine.api.StoreReadLayer;

public class SchemaTransactionStateTest {
    private final int labelId1 = 10;
    private final int labelId2 = 12;
    private final int key1 = 45;
    private final int key2 = 46;
    private final long nodeId = 20L;
    private StoreReadLayer store;
    private TransactionState txState;
    private StateHandlingStatementOperations txContext;
    private KernelStatement state;
    private StoreStatement storeStatement;

    private static IndexDescriptor indexCreate(StateHandlingStatementOperations txContext, KernelStatement state, int labelId, int propertyKey) {
        return txContext.indexCreate(state, SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propertyKey}));
    }

    private static IndexDescriptor indexGetForLabelAndPropertyKey(StateHandlingStatementOperations txContext, KernelStatement state, int labelId, int propertyKey) {
        LabelSchemaDescriptor schemaDescriptor = SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propertyKey});
        return txContext.indexGetForSchema(state, schemaDescriptor);
    }

    private static IndexDescriptor indexGetForLabelAndPropertyKey(StoreReadLayer store, int labelId, int propertyKey) {
        return store.indexGetForSchema(SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propertyKey}));
    }

    @Test
    public void addedRuleShouldBeVisibleInTx() throws Exception {
        this.commitNoLabels();
        IndexDescriptor index = SchemaTransactionStateTest.indexCreate(this.txContext, this.state, 10, 45);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new IndexDescriptor[]{index}), (Object)Iterators.asSet((Iterator)this.txContext.indexesGetForLabel(this.state, 10)));
        ((StoreReadLayer)Mockito.verify((Object)this.store)).indexesGetForLabel(10);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new IndexDescriptor[]{index}), (Object)Iterators.asSet((Iterator)this.txContext.indexesGetAll(this.state)));
        ((StoreReadLayer)Mockito.verify((Object)this.store)).indexesGetAll();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.store});
    }

    @Test
    public void addedRulesShouldBeVisibleInTx() throws Exception {
        this.commitNoLabels();
        IndexDescriptor rule1 = SchemaTransactionStateTest.indexCreate(this.txContext, this.state, 10, 45);
        IndexDescriptor rule2 = SchemaTransactionStateTest.indexCreate(this.txContext, this.state, 12, 46);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new IndexDescriptor[]{rule1}), (Object)Iterators.asSet((Iterator)this.txContext.indexesGetForLabel(this.state, 10)));
        ((StoreReadLayer)Mockito.verify((Object)this.store)).indexesGetForLabel(10);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new IndexDescriptor[]{rule2}), (Object)Iterators.asSet((Iterator)this.txContext.indexesGetForLabel(this.state, 12)));
        ((StoreReadLayer)Mockito.verify((Object)this.store)).indexesGetForLabel(12);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new IndexDescriptor[]{rule1, rule2}), (Object)Iterators.asSet((Iterator)this.txContext.indexesGetAll(this.state)));
        ((StoreReadLayer)Mockito.verify((Object)this.store)).indexesGetAll();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.store});
    }

    @Test
    public void addedAdditionalRuleShouldBeVisibleInTx() throws Exception {
        this.commitNoLabels();
        IndexDescriptor rule1 = SchemaTransactionStateTest.indexCreate(this.txContext, this.state, 10, 45);
        IndexDescriptor rule2 = SchemaTransactionStateTest.indexCreate(this.txContext, this.state, 10, 46);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new IndexDescriptor[]{rule1, rule2}), (Object)Iterators.asSet((Iterator)this.txContext.indexesGetForLabel(this.state, 10)));
    }

    @Test
    public void creatingAnIndexShouldBePopulatingStateWithinTX() throws Exception {
        this.commitLabels(10);
        IndexDescriptor rule = SchemaTransactionStateTest.indexCreate(this.txContext, this.state, 10, 45);
        Assert.assertEquals((Object)InternalIndexState.POPULATING, (Object)this.txContext.indexGetState(this.state, rule));
    }

    @Test
    public void shouldReturnNonExistentRuleAddedInTransaction() throws Exception {
        SchemaTransactionStateTest.indexCreate(this.txContext, this.state, 10, 45);
        IndexDescriptor index = SchemaTransactionStateTest.indexGetForLabelAndPropertyKey(this.txContext, this.state, 10, 45);
        Iterator labelRules = this.txContext.indexesGetForLabel(this.state, 10);
        IndexDescriptor expectedRule = IndexDescriptorFactory.forLabel((int)10, (int[])new int[]{45});
        Assert.assertEquals((Object)expectedRule, (Object)index);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new IndexDescriptor[]{expectedRule}), (Object)Iterators.asSet((Iterator)labelRules));
    }

    @Test
    public void shouldReturnNonExistentRuleAddedInTransactionFromLookup() throws Exception {
        IndexDescriptor existingRule1 = IndexDescriptorFactory.forLabel((int)10, (int[])new int[]{45});
        Mockito.when((Object)SchemaTransactionStateTest.indexGetForLabelAndPropertyKey(this.store, 10, 45)).thenReturn((Object)existingRule1);
        IndexDescriptor existingRule2 = IndexDescriptorFactory.forLabel((int)12, (int[])new int[]{46});
        Mockito.when((Object)SchemaTransactionStateTest.indexGetForLabelAndPropertyKey(this.store, 12, 46)).thenReturn((Object)existingRule2);
        SchemaTransactionStateTest.indexCreate(this.txContext, this.state, 10, 46);
        IndexDescriptor index = SchemaTransactionStateTest.indexGetForLabelAndPropertyKey(this.txContext, this.state, 10, 46);
        Assert.assertEquals((Object)IndexDescriptorFactory.forLabel((int)10, (int[])new int[]{46}), (Object)index);
    }

    @Test
    public void shouldNotReturnRulesAddedInTransactionWithDifferentLabelOrPropertyFromLookup() throws Exception {
        IndexDescriptor existingIndex1 = IndexDescriptorFactory.forLabel((int)10, (int[])new int[]{45});
        Mockito.when((Object)SchemaTransactionStateTest.indexGetForLabelAndPropertyKey(this.store, 10, 45)).thenReturn((Object)existingIndex1);
        IndexDescriptor existingIndex2 = IndexDescriptorFactory.forLabel((int)12, (int[])new int[]{46});
        Mockito.when((Object)SchemaTransactionStateTest.indexGetForLabelAndPropertyKey(this.store, 12, 46)).thenReturn((Object)existingIndex2);
        SchemaTransactionStateTest.indexCreate(this.txContext, this.state, 10, 46);
        IndexDescriptor lookupRule1 = SchemaTransactionStateTest.indexGetForLabelAndPropertyKey(this.txContext, this.state, 10, 45);
        IndexDescriptor lookupRule2 = SchemaTransactionStateTest.indexGetForLabelAndPropertyKey(this.txContext, this.state, 12, 46);
        Assert.assertEquals((Object)existingIndex1, (Object)lookupRule1);
        Assert.assertEquals((Object)existingIndex2, (Object)lookupRule2);
    }

    @Test
    public void shouldNotReturnExistentRuleDroppedInTransaction() throws Exception {
        IndexDescriptor index = IndexDescriptorFactory.forLabel((int)10, (int[])new int[]{45});
        Mockito.when((Object)this.store.indexesGetForLabel(10)).thenReturn(Iterables.option((Object)index).iterator());
        this.txContext.indexDrop(this.state, index);
        Assert.assertNull((Object)SchemaTransactionStateTest.indexGetForLabelAndPropertyKey(this.txContext, this.state, 10, 45));
        Iterator rulesByLabel = this.txContext.indexesGetForLabel(this.state, 10);
        Assert.assertEquals((Object)Iterators.emptySetOf(IndexDescriptor.class), (Object)Iterators.asSet((Iterator)rulesByLabel));
    }

    @Before
    public void before() throws Exception {
        this.txState = new TxState();
        this.state = StatementOperationsTestHelper.mockedState(this.txState);
        this.store = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        Mockito.when((Object)this.store.indexesGetForLabel(10)).then(SchemaTransactionStateTest.asAnswer(Collections.emptyList()));
        Mockito.when((Object)this.store.indexesGetForLabel(12)).then(SchemaTransactionStateTest.asAnswer(Collections.emptyList()));
        Mockito.when((Object)this.store.indexesGetAll()).then(SchemaTransactionStateTest.asAnswer(Collections.emptyList()));
        this.txContext = new StateHandlingStatementOperations(this.store, (AutoIndexing)Mockito.mock(InternalAutoIndexing.class), (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class), (LegacyIndexStore)Mockito.mock(LegacyIndexStore.class));
        this.storeStatement = (StoreStatement)Mockito.mock(StoreStatement.class);
        Mockito.when((Object)this.state.getStoreStatement()).thenReturn((Object)this.storeStatement);
    }

    private static <T> Answer<Iterator<T>> asAnswer(final Iterable<T> values) {
        return new Answer<Iterator<T>>(){

            public Iterator<T> answer(InvocationOnMock invocation) throws Throwable {
                return values.iterator();
            }
        };
    }

    private static Labels labels(long nodeId, int ... labelIds) {
        return new Labels(nodeId, labelIds);
    }

    private void commitLabels(Labels ... labels) throws Exception {
        HashMap<Integer, ArrayList<Long>> allLabels = new HashMap<Integer, ArrayList<Long>>();
        for (Labels nodeLabels : labels) {
            Mockito.when((Object)this.storeStatement.acquireSingleNodeCursor(nodeLabels.nodeId)).thenReturn(StubCursors.asNodeCursor(nodeLabels.nodeId, StubCursors.labels(nodeLabels.labelIds)));
            for (int label : nodeLabels.labelIds) {
                ArrayList<Long> nodes = (ArrayList<Long>)allLabels.get(label);
                if (nodes == null) {
                    nodes = new ArrayList<Long>();
                    allLabels.put(label, nodes);
                }
                nodes.add(nodeLabels.nodeId);
            }
        }
        for (Map.Entry entry : allLabels.entrySet()) {
            Mockito.when((Object)this.store.nodesGetForLabel(this.state.getStoreStatement(), ((Integer)entry.getKey()).intValue())).then(SchemaTransactionStateTest.asAnswer((Iterable)entry.getValue()));
        }
    }

    private void commitNoLabels() throws Exception {
        this.commitLabels(new int[0]);
    }

    private void commitLabels(int ... labels) throws Exception {
        this.commitLabels(SchemaTransactionStateTest.labels(20L, labels));
    }

    private static class Labels {
        private final long nodeId;
        private final int[] labelIds;

        Labels(long nodeId, int ... labelIds) {
            this.nodeId = nodeId;
            this.labelIds = labelIds;
        }
    }
}

