/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;

@RunWith(value=Parameterized.class)
public class TestRelationshipCount {
    private static GraphDatabaseAPI db;
    private Transaction tx;

    @Parameterized.Parameters(name="denseNodeThreshold={0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        int max = Integer.parseInt(GraphDatabaseSettings.dense_node_threshold.getDefaultValue());
        for (int i = 1; i < max; ++i) {
            data.add(new Object[]{i});
        }
        return data;
    }

    @AfterClass
    public static void shutdownDb() {
        db.shutdown();
    }

    public TestRelationshipCount(int denseNodeThreshold) {
        if (db == null || (Integer)((Config)db.getDependencyResolver().resolveDependency(Config.class)).get(GraphDatabaseSettings.dense_node_threshold) != denseNodeThreshold) {
            if (db != null) {
                db.shutdown();
            }
            db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.dense_node_threshold, String.valueOf(denseNodeThreshold)).newGraphDatabase();
        }
    }

    @Test
    public void convertNodeToDense() throws Exception {
        Node node = this.getGraphDb().createNode();
        EnumMap rels = new EnumMap(MyRelTypes.class);
        for (MyRelTypes type : MyRelTypes.values()) {
            rels.put(type, new HashSet());
        }
        int expectedRelCount = 0;
        int i = 0;
        while (i < 6) {
            MyRelTypes type = MyRelTypes.values()[i % MyRelTypes.values().length];
            Relationship rel = node.createRelationshipTo(this.getGraphDb().createNode(), (RelationshipType)type);
            ((Set)rels.get((Object)type)).add(rel);
            ++i;
            ++expectedRelCount;
        }
        this.newTransaction();
        i = 0;
        while (i < 1000) {
            node.createRelationshipTo(this.getGraphDb().createNode(), (RelationshipType)MyRelTypes.TEST);
            ++i;
            ++expectedRelCount;
        }
        Assert.assertEquals((long)expectedRelCount, (long)node.getDegree());
        Assert.assertEquals((long)expectedRelCount, (long)node.getDegree(Direction.BOTH));
        Assert.assertEquals((long)expectedRelCount, (long)node.getDegree(Direction.OUTGOING));
        Assert.assertEquals((long)0L, (long)node.getDegree(Direction.INCOMING));
        Assert.assertEquals(rels.get((Object)MyRelTypes.TEST2), (Object)Iterables.asSet((Iterable)node.getRelationships(new RelationshipType[]{MyRelTypes.TEST2})));
        Assert.assertEquals(this.join((Set)rels.get((Object)MyRelTypes.TEST_TRAVERSAL), (Set)rels.get((Object)MyRelTypes.TEST2)), (Object)Iterables.asSet((Iterable)node.getRelationships(new RelationshipType[]{MyRelTypes.TEST_TRAVERSAL, MyRelTypes.TEST2})));
    }

    private <T> Set<T> join(Set<T> set, Set<T> set2) {
        HashSet<T> result = new HashSet<T>();
        result.addAll(set);
        result.addAll(set2);
        return result;
    }

    @Test
    public void testGetRelationshipTypesOnDiscreteNode() throws Exception {
        this.testGetRelationshipTypes(this.getGraphDb().createNode(), new HashSet<String>());
    }

    @Test
    public void testGetRelationshipTypesOnDenseNode() throws Exception {
        Node node = this.getGraphDb().createNode();
        Node otherNode = this.getGraphDb().createNode();
        for (int i = 0; i < 300; ++i) {
            node.createRelationshipTo(otherNode, (RelationshipType)RelType.INITIAL);
        }
        this.testGetRelationshipTypes(node, new HashSet<String>(Arrays.asList(RelType.INITIAL.name())));
    }

    private void testGetRelationshipTypes(Node node, Set<String> expectedTypes) throws Exception {
        this.assertExpectedRelationshipTypes(expectedTypes, node, false);
        node.createRelationshipTo(this.getGraphDb().createNode(), (RelationshipType)RelType.TYPE1);
        expectedTypes.add(RelType.TYPE1.name());
        this.assertExpectedRelationshipTypes(expectedTypes, node, false);
        node.createRelationshipTo(this.getGraphDb().createNode(), (RelationshipType)RelType.TYPE1);
        this.assertExpectedRelationshipTypes(expectedTypes, node, true);
        Relationship rel = node.createRelationshipTo(this.getGraphDb().createNode(), (RelationshipType)RelType.TYPE2);
        expectedTypes.add(RelType.TYPE2.name());
        this.assertExpectedRelationshipTypes(expectedTypes, node, false);
        rel.delete();
        expectedTypes.remove(RelType.TYPE2.name());
        this.assertExpectedRelationshipTypes(expectedTypes, node, true);
        node.createRelationshipTo(this.getGraphDb().createNode(), (RelationshipType)RelType.TYPE2);
        node.createRelationshipTo(this.getGraphDb().createNode(), (RelationshipType)RelType.TYPE2);
        expectedTypes.add(RelType.TYPE2.name());
        node.createRelationshipTo(this.getGraphDb().createNode(), (RelationshipType)MyRelTypes.TEST);
        expectedTypes.add(MyRelTypes.TEST.name());
        this.assertExpectedRelationshipTypes(expectedTypes, node, true);
        for (Relationship r : node.getRelationships(new RelationshipType[]{RelType.TYPE1})) {
            this.assertExpectedRelationshipTypes(expectedTypes, node, false);
            r.delete();
        }
        expectedTypes.remove(RelType.TYPE1.name());
        this.assertExpectedRelationshipTypes(expectedTypes, node, true);
    }

    private void assertExpectedRelationshipTypes(Set<String> expectedTypes, Node node, boolean commit) {
        Set actual = Iterables.asSet(this.asStrings(node.getRelationshipTypes()));
        Assert.assertEquals(expectedTypes, (Object)actual);
        if (commit) {
            this.newTransaction();
        }
        Assert.assertEquals(expectedTypes, (Object)Iterables.asSet(this.asStrings(node.getRelationshipTypes())));
    }

    private Iterable<String> asStrings(Iterable<RelationshipType> relationshipTypes) {
        return new IterableWrapper<String, RelationshipType>(relationshipTypes){

            protected String underlyingObjectToObject(RelationshipType object) {
                return object.name();
            }
        };
    }

    @Test
    public void withoutLoops() throws Exception {
        int i;
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Assert.assertEquals((long)0L, (long)node1.getDegree());
        Assert.assertEquals((long)0L, (long)node2.getDegree());
        node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        Assert.assertEquals((long)1L, (long)node1.getDegree());
        Assert.assertEquals((long)1L, (long)node2.getDegree());
        node1.createRelationshipTo(this.getGraphDb().createNode(), (RelationshipType)MyRelTypes.TEST2);
        Assert.assertEquals((long)2L, (long)node1.getDegree());
        Assert.assertEquals((long)1L, (long)node2.getDegree());
        this.newTransaction();
        Assert.assertEquals((long)2L, (long)node1.getDegree());
        Assert.assertEquals((long)1L, (long)node2.getDegree());
        for (i = 0; i < 1000; ++i) {
            if (i % 2 == 0) {
                node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            } else {
                node2.createRelationshipTo(node1, (RelationshipType)MyRelTypes.TEST);
            }
            Assert.assertEquals((long)(i + 2 + 1), (long)node1.getDegree());
            Assert.assertEquals((long)(i + 1 + 1), (long)node2.getDegree());
            if (i % 10 != 0) continue;
            this.newTransaction();
        }
        for (i = 0; i < 2; ++i) {
            Assert.assertEquals((long)1002L, (long)node1.getDegree());
            Assert.assertEquals((long)1002L, (long)node1.getDegree(Direction.BOTH));
            Assert.assertEquals((long)502L, (long)node1.getDegree(Direction.OUTGOING));
            Assert.assertEquals((long)500L, (long)node1.getDegree(Direction.INCOMING));
            Assert.assertEquals((long)1L, (long)node1.getDegree((RelationshipType)MyRelTypes.TEST2));
            Assert.assertEquals((long)1001L, (long)node1.getDegree((RelationshipType)MyRelTypes.TEST));
            Assert.assertEquals((long)1001L, (long)node1.getDegree((RelationshipType)MyRelTypes.TEST, Direction.BOTH));
            Assert.assertEquals((long)501L, (long)node1.getDegree((RelationshipType)MyRelTypes.TEST, Direction.OUTGOING));
            Assert.assertEquals((long)500L, (long)node1.getDegree((RelationshipType)MyRelTypes.TEST, Direction.INCOMING));
            Assert.assertEquals((long)1L, (long)node1.getDegree((RelationshipType)MyRelTypes.TEST2, Direction.OUTGOING));
            Assert.assertEquals((long)0L, (long)node1.getDegree((RelationshipType)MyRelTypes.TEST2, Direction.INCOMING));
            this.newTransaction();
        }
        for (Relationship rel : node1.getRelationships()) {
            rel.delete();
        }
        node1.delete();
        for (Relationship rel : node2.getRelationships()) {
            rel.delete();
        }
        node2.delete();
        this.newTransaction();
    }

    @Test
    public void withLoops() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.getGraphDb().createNode().createRelationshipTo(this.getGraphDb().createNode(), (RelationshipType)MyRelTypes.TEST);
        }
        Node node = this.getGraphDb().createNode();
        Assert.assertEquals((long)0L, (long)node.getDegree());
        node.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
        Assert.assertEquals((long)1L, (long)node.getDegree());
        Node otherNode = this.getGraphDb().createNode();
        Relationship rel2 = node.createRelationshipTo(otherNode, (RelationshipType)MyRelTypes.TEST2);
        Assert.assertEquals((long)2L, (long)node.getDegree());
        Assert.assertEquals((long)1L, (long)otherNode.getDegree());
        this.newTransaction();
        Assert.assertEquals((long)2L, (long)node.getDegree());
        Relationship rel3 = node.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST_TRAVERSAL);
        Assert.assertEquals((long)3L, (long)node.getDegree());
        Assert.assertEquals((long)1L, (long)otherNode.getDegree());
        rel2.delete();
        Assert.assertEquals((long)2L, (long)node.getDegree());
        Assert.assertEquals((long)0L, (long)otherNode.getDegree());
        rel3.delete();
        Assert.assertEquals((long)1L, (long)node.getDegree());
    }

    @Test
    public void ensureRightDegree() throws Exception {
        for (int initialSize : new int[]{0, 95, 200}) {
            this.ensureRightDegree(initialSize, Arrays.asList(TestRelationshipCount.create(RelType.TYPE1, Direction.OUTGOING, 5), TestRelationshipCount.create(RelType.TYPE1, Direction.INCOMING, 2), TestRelationshipCount.create(RelType.TYPE2, Direction.OUTGOING, 6), TestRelationshipCount.create(RelType.TYPE2, Direction.INCOMING, 7), TestRelationshipCount.create(RelType.TYPE2, Direction.BOTH, 3)), Arrays.asList(TestRelationshipCount.delete(RelType.TYPE1, Direction.OUTGOING, 0), TestRelationshipCount.delete(RelType.TYPE1, Direction.INCOMING, 1), TestRelationshipCount.delete(RelType.TYPE2, Direction.OUTGOING, Integer.MAX_VALUE), TestRelationshipCount.delete(RelType.TYPE2, Direction.INCOMING, 1), TestRelationshipCount.delete(RelType.TYPE2, Direction.BOTH, Integer.MAX_VALUE)));
            this.ensureRightDegree(initialSize, Arrays.asList(TestRelationshipCount.create(RelType.TYPE1, Direction.BOTH, 1), TestRelationshipCount.create(RelType.TYPE1, Direction.OUTGOING, 5), TestRelationshipCount.create(RelType.TYPE2, Direction.OUTGOING, 6), TestRelationshipCount.create(RelType.TYPE1, Direction.INCOMING, 2), TestRelationshipCount.create(RelType.TYPE2, Direction.BOTH, 3), TestRelationshipCount.create(RelType.TYPE2, Direction.INCOMING, 7), TestRelationshipCount.create(RelType.TYPE2, Direction.BOTH, 3)), null);
            this.ensureRightDegree(initialSize, Arrays.asList(TestRelationshipCount.create(RelType.TYPE1, Direction.BOTH, 2), TestRelationshipCount.create(RelType.TYPE2, Direction.BOTH, 1), TestRelationshipCount.create(RelType.TYPE1, Direction.OUTGOING, 1), TestRelationshipCount.create(RelType.TYPE2, Direction.OUTGOING, 10), TestRelationshipCount.create(RelType.TYPE1, Direction.INCOMING, 2), TestRelationshipCount.create(RelType.TYPE2, Direction.BOTH, 2), TestRelationshipCount.create(RelType.TYPE2, Direction.INCOMING, 7)), null);
        }
    }

    private void ensureRightDegree(int initialSize, Collection<RelationshipCreationSpec> cspecs, Collection<RelationshipDeletionSpec> dspecs) {
        EnumMap<RelType, int[]> expectedCounts = new EnumMap<RelType, int[]>(RelType.class);
        for (RelType relType : RelType.values()) {
            expectedCounts.put(relType, new int[3]);
        }
        Node me = this.getGraphDb().createNode();
        for (int i = 0; i < initialSize; ++i) {
            me.createRelationshipTo(this.getGraphDb().createNode(), (RelationshipType)RelType.INITIAL);
        }
        this.newTransaction();
        ((int[])expectedCounts.get((Object)((Object)RelType.INITIAL)))[0] = initialSize;
        this.assertCounts(me, expectedCounts);
        int counter = 0;
        for (RelationshipCreationSpec relationshipCreationSpec : cspecs) {
            for (int i = 0; i < relationshipCreationSpec.count; ++i) {
                Node otherNode = null;
                if (relationshipCreationSpec.dir == Direction.OUTGOING) {
                    otherNode = this.getGraphDb().createNode();
                    me.createRelationshipTo(otherNode, (RelationshipType)relationshipCreationSpec.type);
                } else if (relationshipCreationSpec.dir == Direction.INCOMING) {
                    otherNode = this.getGraphDb().createNode();
                    otherNode.createRelationshipTo(me, (RelationshipType)relationshipCreationSpec.type);
                } else {
                    me.createRelationshipTo(me, (RelationshipType)relationshipCreationSpec.type);
                }
                int[] nArray = (int[])expectedCounts.get((Object)relationshipCreationSpec.type);
                int n = relationshipCreationSpec.dir.ordinal();
                nArray[n] = nArray[n] + 1;
                if (otherNode != null) {
                    Assert.assertEquals((long)1L, (long)otherNode.getDegree());
                }
                this.assertCounts(me, expectedCounts);
                if (counter % 3 != 0 || counter <= 0) continue;
                this.newTransaction();
                this.assertCounts(me, expectedCounts);
            }
        }
        this.assertCounts(me, expectedCounts);
        this.newTransaction();
        this.assertCounts(me, expectedCounts);
        counter = 0;
        if (dspecs == null) {
            for (RelType type : RelType.values()) {
                if (!type.measure) continue;
                for (Direction direction : Direction.values()) {
                    int[] counts = (int[])expectedCounts.get((Object)type);
                    if (counts[direction.ordinal()] <= 0) continue;
                    this.deleteOneRelationship(me, type, direction, 0);
                    int n = direction.ordinal();
                    counts[n] = counts[n] - 1;
                    this.assertCounts(me, expectedCounts);
                    if (counter % 3 != 0 || counter <= 0) continue;
                    this.newTransaction();
                    this.assertCounts(me, expectedCounts);
                }
            }
        } else {
            for (RelationshipDeletionSpec relationshipDeletionSpec : dspecs) {
                this.deleteOneRelationship(me, relationshipDeletionSpec.type, relationshipDeletionSpec.dir, relationshipDeletionSpec.which);
                int[] nArray = (int[])expectedCounts.get((Object)relationshipDeletionSpec.type);
                int n = relationshipDeletionSpec.dir.ordinal();
                nArray[n] = nArray[n] - 1;
                this.assertCounts(me, expectedCounts);
                if (counter % 3 != 0 || counter <= 0) continue;
                this.newTransaction();
                this.assertCounts(me, expectedCounts);
            }
        }
        this.assertCounts(me, expectedCounts);
        this.newTransaction();
        this.assertCounts(me, expectedCounts);
        for (Relationship relationship : me.getRelationships()) {
            Node otherNode = relationship.getOtherNode(me);
            if (!otherNode.equals(me)) {
                otherNode.delete();
            }
            relationship.delete();
        }
        me.delete();
    }

    private void assertCounts(Node me, Map<RelType, int[]> expectedCounts) {
        Assert.assertEquals((long)this.totalCount(expectedCounts, Direction.BOTH), (long)me.getDegree());
        Assert.assertEquals((long)this.totalCount(expectedCounts, Direction.BOTH), (long)me.getDegree(Direction.BOTH));
        Assert.assertEquals((long)this.totalCount(expectedCounts, Direction.OUTGOING), (long)me.getDegree(Direction.OUTGOING));
        Assert.assertEquals((long)this.totalCount(expectedCounts, Direction.INCOMING), (long)me.getDegree(Direction.INCOMING));
        for (Map.Entry<RelType, int[]> entry : expectedCounts.entrySet()) {
            RelType type = entry.getKey();
            Assert.assertEquals((long)this.totalCount(entry.getValue(), Direction.BOTH), (long)me.getDegree((RelationshipType)type));
            Assert.assertEquals((long)this.totalCount(entry.getValue(), Direction.OUTGOING), (long)me.getDegree((RelationshipType)type, Direction.OUTGOING));
            Assert.assertEquals((long)this.totalCount(entry.getValue(), Direction.INCOMING), (long)me.getDegree((RelationshipType)type, Direction.INCOMING));
            Assert.assertEquals((long)this.totalCount(entry.getValue(), Direction.BOTH), (long)me.getDegree((RelationshipType)type, Direction.BOTH));
        }
    }

    private int totalCount(Map<RelType, int[]> expectedCounts, Direction direction) {
        int result = 0;
        for (Map.Entry<RelType, int[]> entry : expectedCounts.entrySet()) {
            result += this.totalCount(entry.getValue(), direction);
        }
        return result;
    }

    private int totalCount(int[] expectedCounts, Direction direction) {
        int result = 0;
        if (direction == Direction.OUTGOING || direction == Direction.BOTH) {
            result += expectedCounts[0];
        }
        if (direction == Direction.INCOMING || direction == Direction.BOTH) {
            result += expectedCounts[1];
        }
        return result += expectedCounts[2];
    }

    private void deleteOneRelationship(Node node, RelType type, Direction direction, int which) {
        Relationship last = null;
        int counter = 0;
        for (Relationship rel : node.getRelationships((RelationshipType)type, direction)) {
            if (this.isLoop(rel) != (direction == Direction.BOTH)) continue;
            last = rel;
            if (counter++ != which) continue;
            rel.delete();
            return;
        }
        if (which == Integer.MAX_VALUE && last != null) {
            last.delete();
            return;
        }
        Assert.fail((String)("Couldn't find " + (direction == Direction.BOTH ? "loop" : "non-loop") + " relationship " + type.name() + " " + direction + " to delete"));
    }

    private boolean isLoop(Relationship r) {
        return r.getStartNode().equals(r.getEndNode());
    }

    static RelationshipCreationSpec create(RelType type, Direction dir, int count) {
        return new RelationshipCreationSpec(type, dir, count);
    }

    static RelationshipDeletionSpec delete(RelType type, Direction dir, int which) {
        return new RelationshipDeletionSpec(type, dir, which);
    }

    @Before
    public void newTransaction() {
        if (this.tx != null) {
            this.closeTransaction();
        }
        this.tx = this.getGraphDb().beginTx();
    }

    @After
    public void closeTransaction() {
        assert (this.tx != null);
        this.tx.success();
        this.tx.close();
    }

    private GraphDatabaseService getGraphDb() {
        return db;
    }

    private static enum RelType implements RelationshipType
    {
        INITIAL(false),
        TYPE1(true),
        TYPE2(true);

        boolean measure;

        private RelType(boolean measure) {
            this.measure = measure;
        }
    }

    private static class RelationshipDeletionSpec {
        private final RelType type;
        private final Direction dir;
        private final int which;

        RelationshipDeletionSpec(RelType type, Direction dir, int which) {
            this.type = type;
            this.dir = dir;
            this.which = which;
        }
    }

    private static class RelationshipCreationSpec {
        private final RelType type;
        private final Direction dir;
        private final int count;

        RelationshipCreationSpec(RelType type, Direction dir, int count) {
            this.type = type;
            this.dir = dir;
            this.count = count;
        }
    }
}

