/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.RawCursor;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValueIterator;

public class LabelScanValueIteratorTest {
    @Test
    public void shouldCloseExhaustedCursors() throws Exception {
        RawCursor cursor = (RawCursor)Mockito.mock(RawCursor.class);
        Mockito.when((Object)cursor.next()).thenReturn((Object)false);
        HashSet toRemoveFrom = new HashSet();
        LabelScanValueIterator iterator = new LabelScanValueIterator(cursor, toRemoveFrom);
        ((RawCursor)Mockito.verify((Object)cursor, (VerificationMode)Mockito.times((int)0))).close();
        this.exhaust((PrimitiveLongIterator)iterator);
        ((RawCursor)Mockito.verify((Object)cursor, (VerificationMode)Mockito.times((int)1))).close();
        iterator.hasNext();
        ((RawCursor)Mockito.verify((Object)cursor, (VerificationMode)Mockito.times((int)1))).close();
        Assert.assertTrue((boolean)toRemoveFrom.isEmpty());
    }

    private void exhaust(PrimitiveLongIterator iterator) {
        while (iterator.hasNext()) {
            iterator.next();
        }
    }
}

